#include "main.ih"

void readConfig(Config *myConfig, std::vector<option::Option> options, std::string configPath)
{//move to config class?
    std::ifstream ifs(configPath);
    if (!ifs.good())
    {
        std::cerr << "Could not read configuration: " << configPath << '\n';
        exit(1);
    }
    std::string word1;
    
    ifs >> word1 >> myConfig->numTrain;
    ifs >> word1 >> myConfig->numDev;

    ifs >> word1 >> word1 >> myConfig->w2v;
    myConfig->w2vB = (word1 == "cached");

    ifs >> word1 >> word1 >> myConfig->twitter;
    myConfig->twitterB = (word1 == "cached");

    ifs >> word1 >> word1 >> myConfig->wiki;
    myConfig->wikiB = (word1 == "cached");

    ifs >> word1 >> word1 >> myConfig->knowns;
    myConfig->knownsB = (word1 == "cached");

    ifs >> word1 >> word1 >> myConfig->nes;
    myConfig->nesB = (word1 == "cached");

    ifs >> word1 >> word1 >> myConfig->dict;
    myConfig->dictB = (word1 == "cached");

    ifs >> word1 >> myConfig->aspLan >> myConfig->aspExtra
        >> myConfig->aspMode;

    ifs >> myConfig->parserPath;
    getline(ifs, word1);
    getline(ifs, myConfig->parserArgs);
    ifs.close();

    myConfig->normAll = !options[UNK];
    myConfig->caps = options[CAPS];
    myConfig->goldErrDet = options[GOLD]; 
    myConfig->tokenize = options[TOKENIZE]; 
    myConfig->verbose = options[VERBOSE];
    myConfig->parse = options[PARSE];

    myConfig->goldTreebank = (options[PARSE]) ? options[PARSE].arg : "";
    myConfig->numThreads = (options[THREADS]) ? std::stoi(options[THREADS].arg) : 4;
    myConfig->numCands = (options[CANDS])? std::stoi(options[CANDS].arg): 0;
    myConfig->weight = (options[WEIGHT])? std::stod(options[WEIGHT].arg): 1.0;
    myConfig->seed = (options[SEED])? std::stoi(options[SEED].arg): 5;

    if (myConfig->parse && myConfig->numCands == 0)
        myConfig->numCands = 1; // to ensure output as fsa

    if (options[RANDOMF])
    {
        myConfig->regrPath = options[RANDOMF].arg;
        myConfig->cleanedPath = (myConfig->regrPath.find(".forest") == std::string::npos)? 
                        myConfig->regrPath: 
                        myConfig->regrPath.substr(0, myConfig->regrPath.length()-7);
        myConfig->regrPath = myConfig->cleanedPath + ".forest";
        myConfig->featsPath = myConfig->cleanedPath + ".data";
        myConfig->lookupPath = myConfig->cleanedPath + ".lookup";
    }
    myConfig->lookupPath2 = (options[LOOKUP])? options[LOOKUP].arg: "";

    myConfig->tmpFile = "working/tmp." + std::to_string(getpid());

    std::string feats = (options[FEATURES])? options[FEATURES].arg: "1111111";
    if (feats.size() < 7)
    {
        std::cerr << "Not enough features given: " << feats << '\n';
        exit(0);
    }
    myConfig->featGroups = std::vector<bool>(feats.size(), true);
    for (size_t beg = 0; beg != feats.size(); ++beg)
        myConfig->featGroups[beg] = (feats[beg] == '1');
    myConfig->numFeats = 16;

    myConfig->header = "";
    for (size_t beg =0; beg != myConfig->numFeats-1; ++beg)
        myConfig->header += "feat" + std::to_string(beg) + "\t";
    myConfig->header += "gold\n";

    myConfig->idxs = std::vector<double>(500);
    for (size_t beg = 0; beg != 500; ++beg)
        myConfig->idxs[beg] = (double)beg;
}

