__author__ = 'Luchen'
from flask import Flask, render_template
from flask import request, url_for, redirect, abort
import show_page_prepare


app = Flask(__name__)

ip_list = ['127.0.0.1', '135.0.24.208', '10.20.14.164']
TERMS_PER_LINE = 10
DEFAULT_N = 500
DEFAULT_K = 50


@app.before_request
def limit_remote_addr():
    print request.remote_addr
    if request.remote_addr not in ip_list and not request.remote_addr.startswith('129.97.186'):
        abort(403)


@app.route('/')
def index():
    return redirect(url_for('get_topN_result', top_N=DEFAULT_N, top_K=DEFAULT_K, sort_tag=0))


@app.route('/topFrequent=<int:top_N>&topRanking=<int:top_K>&sort=<int:sort_tag>')
def get_topN_result(top_N, top_K, sort_tag):
    if sort_tag == 0:
        title = 'Ranked By Document Frequency in Twitter'
        the_other_way = 'Ranked By RBO Score'
        other_sort = 1
        lines = show_page_prepare.get_topK_rbo_value(top_N, top_K)
        top_terms = show_page_prepare.split_lines(lines, TERMS_PER_LINE)
    else:
        title = 'Ranked By RBO Score'
        the_other_way = 'Ranked By Document Frequency in Twitter'
        other_sort = 0
        lines = show_page_prepare.get_topK_rbo_value(top_N, top_K)
        sorted_lines = show_page_prepare.sort_topK_by_score(lines)
        top_terms = show_page_prepare.split_lines(sorted_lines, TERMS_PER_LINE)
    return render_template('top_n.html', top_terms=top_terms, title=title, the_other_way=the_other_way,
                           top_N=top_N, top_K=top_K, other_sort=other_sort)


@app.route("/navigate", methods=["GET", "POST"])
def navigate():
    formData = request.form.lists() if request.method == "GET" else request.form.lists()
    top_N = int(formData[0][1][0])
    # print top_N
    top_K = int(formData[1][1][0])
    #print top_K
    if formData[2][1][0] == 'RBO value':
        sort_tag = 1
    else:
        sort_tag = 0
    return redirect(url_for('get_topN_result', top_N=top_N, top_K=top_K, sort_tag=sort_tag))



@app.route('/<term>/top_RBO=<int:topK>')
def get_term_lists(term, topK=DEFAULT_K):
    data, score = show_page_prepare.get_similar_lists_by_term(term, topK)
    return render_template('term_similar_list.html', term_list=data, topK=topK, score=score)



@app.route('/compute_rbo', methods=["GET", "POST"])
def compute_rbo():
    formData = request.form.lists() if request.method == "GET" else request.form.lists()
    print formData
    topK = int(formData[0][1][0])
    term = formData[0][0]
    return redirect(url_for('get_term_lists', term=term, topK=topK))


@app.route('/plots')
def plot():
    return render_template('plots.html')


@app.route("/navigate_distance", methods=["GET", "POST"])
def navigate_distance():
    formData = request.form.lists() if request.method == "GET" else request.form.lists()
    print formData
    top_N = int(formData[0][1][0])
    method = formData[1][1][0]
    if formData[3][1][0] == 'frequency':
        sort_tag = '1'
    elif formData[3][1][0] == 'top5000':
        sort_tag = '-1'
    else:
        sort_tag = '0'
    return redirect(url_for('distance_to_median', method=method, top_N=top_N, sorted=sort_tag))


@app.route('/distance_to_median/<method>:topN=<int:top_N>?sort=<sorted>')
def distance_to_median(method, top_N, sorted):
    word_list = show_page_prepare.read_in_median_distance(method, top_N=top_N)
    if sorted != '0':
        word_list = show_page_prepare.sort_topK_by_rank(word_list)
    if sorted == '-1':
        word_list = show_page_prepare.read_in_median_distance(method)
        word_list = show_page_prepare.sort_by_distance_in_topK(word_list)
    lines = show_page_prepare.split_lines(word_list, 5)
    return render_template('distance_list.html', method=method, top_N=top_N, lines=lines, sorted=sorted, top_K=50)
if __name__ == '__main__':
    app.run(host='0.0.0.0')
    #app.run(debug=True)
