
(* #load "str.cmxa";; *)

open Str
open String


type 'a child_list = End | Term of 'a | ChildList of 'a child_list * 'a child_list;;


(* read in tree *)
let rec tree_of_string = function
    s when length s = 0 ->
      s, End
  | s when get s 0 = ' ' ->
      tree_of_string (string_after s 1)
  | s when get s 0 = '(' ->
      let r, t0 = tree_of_string (string_after s 1) in
      let r, t  = tree_of_string r in
      r, ChildList(t0, t)
  | s when get s 0 = ')' ->
      (string_after s 1), End
  | s when string_match (regexp "[^ ()]+") s 0 ->
      let c = matched_string s in
      let r, t = tree_of_string (string_after s (match_end ())) in
      r, ChildList ( Term ( c ), t )
  | s ->
      s, End;;


(* write out tree *)
let rec string_of_tree = function
    ChildList(Term(s),End) -> s
  | ChildList(Term(s),t)   -> s^" "^(string_of_tree t)
  | ChildList(tc,End)      -> "("^(string_of_tree tc)^")"
  | ChildList(tc,t)        -> "("^(string_of_tree tc)^") "^(string_of_tree t)
  | Term(s)                -> s
  | End                    -> "";;


