###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

require 'scripts/umnlp.rb'

#################
# addElided.rb
# Takes in an elision model and a corpus containing unf categories,
# and fills in the unfinished nodes with filler constituents based on
# a model of likely finishers.
################


class Tree
  attr_reader :prob
  attr_writer :prob
  
  def copy
    t = Tree.new
    t.head = @head
    t.prob = @prob
    @children.each{ |child|
      t.children << child.copy
    }
    return t
  end
end

class Forest
  attr_accessor :label, :prob, :subtrees

  def initialize(t)
    @orig_tree = t
    @probs = Array.new
    @probs[0] = 1.0 #t.prob
    @label = t.head
    @subtrees = Array.new
    @subtrees[0] = Array.new
    
    t.children.each{ |child|
      child.prob = 1.0
      @subtrees[0] << Forest.new(child)
    }
  end
  
  ########################
  ## returnAllTrees
  ## Extract an array of Tree objects from this forest object
  ###########################
  def returnAllTrees
#    $stderr.puts "returning all my trees: #{@label}"
    if @subtrees[0].size == 0
      t = Tree.new
      t.head = @label
      t.prob = @probs[0]
#      $stderr.puts "I'm done: #{@label}"
      return Array.[](t)
    end
    
    trees = Array.new
    ## Get the arrays of all my subtrees
#    $stderr.puts "   I have #{@subtrees.size} subtrees"
    @subtrees.each_index{ |i|
      subtree = @subtrees[i]
      new_ra = Array.new
      my_tree = Tree.new
      my_tree.head = @label
      my_tree.prob = @probs[i]
      new_ra << my_tree
      subtree.each{ |child|
        temp = child.returnAllTrees
        temp_ra = Array.new
        new_ra.each{ |partial|
          temp.each{ |tree|
#            $stderr.puts "temp size = #{temp.size}, partial = #{partial.head}, tree = #{tree.head}, partial prob = #{partial.prob}"
            temp_tree = partial.copy
            temp_tree.children << tree
            temp_tree.prob *= tree.prob
            temp_ra << temp_tree
          }
        }
        new_ra = temp_ra
      }
      trees << new_ra
      trees.flatten!
    }
    
#    $stderr.puts "I'm done: #{@label} returning #{trees.size} trees"
    
    return trees
    ## We have all of our child arrays
    
  end
  
  ##########################
  ## fillUnfs
  ## Using the elision model, fill out the unf categories probabilistically
  #######################################
  def fillUnfs(sample=false)
    ## At the start, there is only one subtree
    if @subtrees[0].size == 0
      return false
    end
    unfChild = false
    
    if @label =~ /(.*)UNF/
      @label = $1.sub(/^([A-Z$]+).*/, '\1')
      #@orig_tree.head.sub!(/^([A-Z$]+).*/, '\1')
      key = "#{@label}"
      @subtrees[0].each{ |child|
        key += " #{child.label.sub(/^([A-Z$]+).*/, '\1')}"
      }

      if $unfHash.has_key?(key)
        @subtrees = Array.new
        @probs = Array.new
        outcomes = $unfHash[key]
        if sample
          cum = 0.0
          dart = rand
 #         $stderr.puts "Random dart is #{dart}"
          outcomes.each{ |valueprob|
            cum += valueprob.prob
            if dart < cum
              new_tree = Tree.new(@orig_tree.to_s)
              new_tree.children << Tree.new("(#{valueprob.value} __eli)")
              @probs << valueprob.prob
              @subtrees << Array.new
              new_tree.children.each { |tree|
                @subtrees.last << Forest.new(tree)
              }
              break
            end
          }
          #$stderr.puts "dart = #{dart}, cum= #{cum}, key=#{key}"
        else
          outcomes.each{ |valueprob|
            new_tree = Tree.new(@orig_tree.to_s)
            new_tree.children << Tree.new("(#{valueprob.value} __eli)")
            @probs << valueprob.prob
            @subtrees << Array.new
            new_tree.children.each { |tree|
              @subtrees.last << Forest.new(tree)
            }
          }
        end
        unfChild = true
      elsif $rcHash.has_key?(@label)
        @subtrees = Array.new
        @probs = Array.new
        outcomes = $rcHash[@label]
        if sample
          cum = 0.0
          dart = rand
#          $stderr.puts "Random dart is #{dart}"
          outcomes.each{ |valueprob|
            cum += valueprob.prob
            if dart < cum
              new_tree = Tree.new(@orig_tree.to_s)
              new_tree.children << Tree.new("(#{valueprob.value} __eli)")
              @probs << valueprob.prob
              @subtrees << Array.new
              new_tree.children.each { |tree|
                @subtrees.last << Forest.new(tree)
              }
              break
            end
          }       
          #$stderr.puts "dart = #{dart}, cum= #{cum}, key=#{key}"
        else
          outcomes.each{ |valueprob|
            new_tree = Tree.new(@orig_tree.to_s)
            new_tree.children << Tree.new("(#{valueprob.value} __eli)")
            @probs << valueprob.prob
            @subtrees << Array.new
            new_tree.children.each { |tree|
              @subtrees.last << Forest.new(tree)
            }
          }
        end
        unfChild = true
      else
        ## Unfortunately we weren't able to fill in the unf
        @label += "UNF"
      end
    end #else
    ## I'm not an unf category
    ## Keep track of whether we've made an "-unf"-split
    @subtrees.each_index{ |i|
     @subtrees[i].each{ |childForest|
      unfChild |= childForest.fillUnfs(sample)
     }
    }
    if unfChild and @label =~ /EDITED(.+)/
      @label = $1
      return false
    elsif unfChild and @label == "EDITED"
      @label = @subtrees[0][0].label
      return false
    elsif unfChild
      return true
    else
      return false
    end
  end
  
  def printAllTrees(prefix="", prob=1.0)
    if @subtrees[0].size == 0
      prefix += " @label"
      return
    end
    
    @subtrees.each{ |subtree|
      prefix = "(#{@label} "
      subtree.each{ |child|
      }
    }
  end
end

$unfHash = Hash.new
$rcHash = Hash.new
#toProcess = Queue.new
line_num = 0

while(line = gets)
 begin
  line.chomp!
  if line =~ /^UN (.*) : (.*) = (.*)/
    if not $unfHash.has_key?($1)
      $unfHash[$1] = Array.new
    end
    $unfHash[$1] << ValueProb.new($2, $3.to_f)
  elsif line =~ /^RC (.*) : (.*) = (.*)/
    if not $rcHash.has_key?($1)
      $rcHash[$1] = Array.new
    end
    $rcHash[$1] << ValueProb.new($2, $3.to_f)   
  else
    line_num += 1
    if not line =~ /UNF/
      puts "#{line} : 1.0"
      next
    end
    #$stderr.puts "Working on tree: #{line}"
    t = Tree.new(line)
    f = Forest.new(t)
    f.fillUnfs(true)
    trees = f.returnAllTrees
    trees.each{ |tree|
      puts "#{tree.to_s} : #{tree.prob}"
    }
  end  
 rescue
   $stderr.puts "Rescued at line #{line_num}: " + $!
 end
end
