// Copyright 2013 Thomas Müller
// This file is part of MarMoT, which is licensed under GPLv3.

package marmot.morph;

import java.util.HashMap;
import java.util.Map;

import marmot.core.Options;



public class MorphOptions extends Options {
	private static final long serialVersionUID = 1L;
	public static final String TRAIN_FILE = "train-file";
	public static final String TEST_FILE = "test-file";
	public static final String RARE_WORD_MAX_FREQ = "rare-word-max-freq";
	public static final String SHAPE_TRIE_PATH = "shape-trie-path";
	public static final String MODEL_FILE = "model-file";
	public static final String RESTRICT_TRANSITIONS = "restrict-transitions";
	public static final String SUBPOS_TO_POS = "subpos-to-pos";
	public static final String SHAPE = "shape";
	public static final String TAG_MORPH = "tag-morph";
	public static final String PRED_FILE = "pred-file";
	public static final String OBSERVED_FEATURE = "observed-feature";
	public static final String SPLIT_MORPHS = "split-morphs";
	public static final String SUBTAG_SEPERATOR = "subtag-seperator";
	public static final String MORPH_DICT = "mdict";
	public static final String SPLIT_POS = "split-pos";
	
	private static final Map<String, String> DEFALUT_VALUES_ = new HashMap<String, String>();

	static {
		DEFALUT_VALUES_.put(TRAIN_FILE, "");
		DEFALUT_VALUES_.put(TEST_FILE, "");
		DEFALUT_VALUES_.put(PRED_FILE, "");
		DEFALUT_VALUES_.put(RARE_WORD_MAX_FREQ, "10");
		DEFALUT_VALUES_.put(SHAPE_TRIE_PATH, "");
		DEFALUT_VALUES_.put(MODEL_FILE, "");
		DEFALUT_VALUES_.put(RESTRICT_TRANSITIONS, "true");
		DEFALUT_VALUES_.put(SUBPOS_TO_POS, "false");
		DEFALUT_VALUES_.put(SHAPE, "true");
		DEFALUT_VALUES_.put(TAG_MORPH, "true");
		DEFALUT_VALUES_.put(OBSERVED_FEATURE, "true");
		DEFALUT_VALUES_.put(SPLIT_POS, "false");
		DEFALUT_VALUES_.put(SPLIT_MORPHS, "true");
		DEFALUT_VALUES_.put(SUBTAG_SEPERATOR, "\\|");
		DEFALUT_VALUES_.put(MORPH_DICT, "");
	}


	
	public MorphOptions() {
		super();
		putAll(DEFALUT_VALUES_);
	}
	
	public String getTrainFile() {
		return getProperty(TRAIN_FILE);
	}

	public String getTestFile() {
		return getProperty(TEST_FILE);
	}
	
	public int getRareWordMaxFreq() {
		return Integer.parseInt(getProperty(RARE_WORD_MAX_FREQ));
	}
	
	public boolean getRestricTransitions() {
		return Boolean.parseBoolean(getProperty(RESTRICT_TRANSITIONS));
	}
	
	public boolean getTagMorph() {
		return Boolean.valueOf(getProperty(TAG_MORPH));
	}
	
	public String getPredFile() {
		return getProperty(PRED_FILE);
	}
	
	public boolean getSubPosToPos() {
		return Boolean.parseBoolean(getProperty(SUBPOS_TO_POS));
	}

	public boolean getShape() {
		return Boolean.parseBoolean(getProperty(SHAPE));
	}
	
	public String getShapeTriePath() {
		return getProperty(SHAPE_TRIE_PATH);
	}

	public String getModelFile() {
		return getProperty(MODEL_FILE);
	}

	public boolean getObservedFeature() {
		return Boolean.parseBoolean(getProperty(OBSERVED_FEATURE));
	}

	public boolean getSplitMorphs() {
		return Boolean.parseBoolean(getProperty(SPLIT_MORPHS));
	}
	
	public String getSubTagSeperator() {
		return getProperty(SUBTAG_SEPERATOR);
	}

	public String getMorphDict() {
		return getProperty(MORPH_DICT);
	}

	public boolean getSplitPos() {
		return Boolean.parseBoolean(getProperty(SPLIT_POS));
	}
}
