/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.uarcstandard;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.uarcstandard.UArcStanAddressFunction;
import org.maltparser.parser.algorithm.uarcstandard.UArcStanConfig;

public abstract class UNivreFactory
implements AbstractParserFactory {
    protected Algorithm algorithm;
    protected DependencyParserConfig manager;

    public UNivreFactory(Algorithm algorithm) {
        this.setAlgorithm(algorithm);
        this.setManager(algorithm.getManager());
    }

    public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Parser configuration : Undirected Nivre with " + this.manager.getOptionValue("nivre", "root_handling").toString().toUpperCase() + " root handling, reconstruction = " + this.manager.getOptionValue("2planar3t", "2reconstruction").toString().toUpperCase() + ", heuristic = " + this.manager.getOptionValue("planar3tlab", "heuristic").toString().toUpperCase() + "\n");
        }
        return new UArcStanConfig(this.manager.getSymbolTables(), this.manager.getOptionValue("nivre", "root_handling").toString(), this.manager.getOptionValue("2planar3t", "2reconstruction").toString(), this.manager.getOptionValue("planar3tlab", "heuristic").toString());
    }

    public Function makeFunction(String subFunctionName) throws MaltChainedException {
        return new UArcStanAddressFunction(subFunctionName, this.algorithm);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public DependencyParserConfig getManager() {
        return this.manager;
    }

    public void setManager(DependencyParserConfig manager) {
        this.manager = manager;
    }
}

