/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.TreeSet;
import settings.Parameters;
import tsg.CFSG;
import util.FileUtil;
import util.Utility;

public class Grammar {
    int lexCount;
    int catCount;
    String[] lexArray;
    String[] catArray;
    Hashtable<String, Integer> lexIndex;
    Hashtable<String, Integer> catIndex;
    int[][] rulesOfWord;
    int[][] binaryRulesOfLeftChild;
    int[][] unaryRulesOfLeftChild;
    int[][] intBinaryRules;
    int[][] intUnaryRules;
    int[][] lexRules;
    int intBinaryRulesSize;
    int intUnaryRulesSize;
    int lexRulesSize;
    double[] intBinaryLogProb;
    double[] intUnaryLogProb;
    double[] lexLogProb;
    int maxCycleUnaryProduction;
    File logFile;

    public Grammar(CFSG<? extends Number> grammar) {
        this(grammar.lexRules, grammar.internalRules);
        this.logFile = Parameters.logFile;
    }

    public Grammar(Hashtable<String, ? extends Number> lexRulesTable, Hashtable<String, ? extends Number> intRulesTable) {
        this.readGrammar(lexRulesTable, intRulesTable);
        this.printGrammarStatistics();
    }

    private void printGrammarStatistics() {
        FileUtil.appendReturn("\t...done", Parameters.logFile);
        FileUtil.appendReturn("\t# of words: " + this.lexArray.length, Parameters.logFile);
        FileUtil.appendReturn("\t# of categories: " + this.catArray.length, Parameters.logFile);
    }

    public int getIndexOfWord(String word) {
        Integer index = this.lexIndex.get(word);
        if (index == null) {
            System.err.println(String.valueOf(word) + " unknown");
            System.exit(-1);
        }
        return index;
    }

    private void readGrammar(Hashtable<String, ? extends Number> lexRulesTable, Hashtable<String, ? extends Number> intRulesTable) {
        String[] ruleSplit;
        double count;
        String rule;
        FileUtil.appendReturn("Starting fedePar ... reading grammar", Parameters.logFile);
        TreeSet<String> lexicon = new TreeSet<String>();
        TreeSet<String> categories = new TreeSet<String>();
        Hashtable<String, Double> intCatFreqTable = new Hashtable<String, Double>();
        Hashtable<String, Double> posCatFreqTable = new Hashtable<String, Double>();
        this.lexRulesSize = lexRulesTable.size();
        Enumeration<String> e = lexRulesTable.keys();
        while (e.hasMoreElements()) {
            rule = e.nextElement();
            count = lexRulesTable.get(rule).doubleValue();
            ruleSplit = rule.split(" ");
            Utility.increaseStringDouble(posCatFreqTable, ruleSplit[0], count);
            categories.add(ruleSplit[0]);
            lexicon.add(ruleSplit[1]);
        }
        e = intRulesTable.keys();
        while (e.hasMoreElements()) {
            rule = e.nextElement();
            count = intRulesTable.get(rule).doubleValue();
            ruleSplit = rule.split(" ");
            Utility.increaseStringDouble(intCatFreqTable, ruleSplit[0], count);
            categories.add(ruleSplit[0]);
            categories.add(ruleSplit[1]);
            if (ruleSplit.length > 2) {
                categories.add(ruleSplit[2]);
                ++this.intBinaryRulesSize;
                continue;
            }
            ++this.intUnaryRulesSize;
        }
        HashSet overlapping = new HashSet(posCatFreqTable.keySet());
        overlapping.retainAll(intCatFreqTable.keySet());
        if (!overlapping.isEmpty()) {
            System.out.println("Overlapping between internal nodes and pos tags: " + overlapping.toString());
        }
        this.lexCount = lexicon.size();
        this.catCount = categories.size();
        this.lexArray = lexicon.toArray(new String[0]);
        this.catArray = categories.toArray(new String[0]);
        this.lexIndex = new Hashtable();
        this.catIndex = new Hashtable();
        int i = 0;
        while (i < this.lexArray.length) {
            this.lexIndex.put(this.lexArray[i], i);
            ++i;
        }
        i = 0;
        while (i < this.catArray.length) {
            this.catIndex.put(this.catArray[i], i);
            ++i;
        }
        this.readRules(lexRulesTable, intRulesTable, posCatFreqTable, intCatFreqTable);
    }

    private void readRules(Hashtable<String, ? extends Number> lexRulesTable, Hashtable<String, ? extends Number> intRulesTable, Hashtable<String, Double> posCatFreqTable, Hashtable<String, Double> intCatFreqTable) {
        this.lexRules = new int[this.lexRulesSize][2];
        this.lexLogProb = new double[this.lexRulesSize];
        this.intBinaryRules = new int[this.intBinaryRulesSize][3];
        this.intBinaryLogProb = new double[this.intBinaryRulesSize];
        this.intUnaryRules = new int[this.intUnaryRulesSize][2];
        this.intUnaryLogProb = new double[this.intUnaryRulesSize];
        this.rulesOfWord = new int[this.lexCount][];
        this.binaryRulesOfLeftChild = new int[this.catCount][];
        this.unaryRulesOfLeftChild = new int[this.catCount][];
        int lexRuleCount = 0;
        Enumeration<String> e = lexRulesTable.keys();
        while (e.hasMoreElements()) {
            String rule = e.nextElement();
            double count = lexRulesTable.get(rule).doubleValue();
            String[] ruleSplit = rule.split(" ");
            int parentIndex = this.catIndex.get(ruleSplit[0]);
            int wordIndex = this.lexIndex.get(ruleSplit[1]);
            double parentFreq = posCatFreqTable.get(ruleSplit[0]);
            this.lexRules[lexRuleCount] = new int[]{parentIndex, wordIndex};
            this.lexLogProb[lexRuleCount] = Math.log(count / parentFreq);
            this.rulesOfWord[wordIndex] = Utility.appendIntArraySet(this.rulesOfWord[wordIndex], lexRuleCount);
            ++lexRuleCount;
        }
        int intBinaryRuleCount = 0;
        int intUnaryRuleCount = 0;
        Enumeration<String> e2 = intRulesTable.keys();
        while (e2.hasMoreElements()) {
            String rule = e2.nextElement();
            double count = intRulesTable.get(rule).doubleValue();
            String[] ruleSplit = rule.split(" ");
            int parentIndex = this.catIndex.get(ruleSplit[0]);
            int leftDaughterIndex = this.catIndex.get(ruleSplit[1]);
            double parentFreq = intCatFreqTable.get(ruleSplit[0]);
            if (ruleSplit.length > 2) {
                int rightDaughterIndex = this.catIndex.get(ruleSplit[2]);
                this.intBinaryRules[intBinaryRuleCount] = new int[]{parentIndex, leftDaughterIndex, rightDaughterIndex};
                this.intBinaryLogProb[intBinaryRuleCount] = Math.log(count / parentFreq);
                this.binaryRulesOfLeftChild[leftDaughterIndex] = Utility.appendIntArraySet(this.binaryRulesOfLeftChild[leftDaughterIndex], intBinaryRuleCount);
                ++intBinaryRuleCount;
                continue;
            }
            this.intUnaryRules[intUnaryRuleCount] = new int[]{parentIndex, leftDaughterIndex};
            this.intUnaryLogProb[intUnaryRuleCount] = Math.log(count / parentFreq);
            this.unaryRulesOfLeftChild[leftDaughterIndex] = Utility.appendIntArraySet(this.unaryRulesOfLeftChild[leftDaughterIndex], intUnaryRuleCount);
            ++intUnaryRuleCount;
        }
    }

    public void checkRecursiveUnaryProductions() {
        int i = 0;
        while (i < this.intUnaryRules.length) {
            if (this.intUnaryRules[i][0] == this.intUnaryRules[i][1]) {
                String logMessage = "Recursive unary production: " + this.catArray[this.intUnaryRules[i][0]] + " --> " + this.catArray[this.intUnaryRules[i][1]];
                FileUtil.appendReturn(logMessage, this.logFile);
            } else {
                int[] rules = this.unaryRulesOfLeftChild[this.intUnaryRules[i][0]];
                if (rules != null) {
                    int j = 0;
                    while (j < rules.length) {
                        int[] rule = this.intUnaryRules[rules[j]];
                        if (rule[0] == this.intUnaryRules[i][1]) {
                            String logMessage = "Recursive unary production: " + this.catArray[this.intUnaryRules[i][0]] + " --> " + this.catArray[this.intUnaryRules[i][1]] + " | " + this.catArray[this.intUnaryRules[i][1]] + " --> " + this.catArray[this.intUnaryRules[i][0]];
                            FileUtil.appendReturn(logMessage, this.logFile);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public void checkCircularUnaryProductions(int limit) {
        int i = 0;
        while (i < this.catCount) {
            this.goUpUnaryProduction(i, 0, limit);
            ++i;
        }
    }

    private void goUpUnaryProduction(int uniqueChild, int loop, int limit) {
        int[] possibleRules = this.unaryRulesOfLeftChild[uniqueChild];
        if (possibleRules == null) {
            return;
        }
        if (loop > limit) {
            this.maxCycleUnaryProduction = loop;
            System.err.println("Cyclic Unary Production: reached loop of level " + loop);
            System.exit(-1);
        }
        if (loop > this.maxCycleUnaryProduction) {
            this.maxCycleUnaryProduction = loop;
        }
        int i = 0;
        while (i < possibleRules.length) {
            int ruleIndex = possibleRules[i];
            int[] rule = this.intUnaryRules[ruleIndex];
            this.goUpUnaryProduction(rule[0], loop + 1, limit);
            ++i;
        }
    }

    public double getLexLogProb(int rootIndex, int lexIndex) {
        int[] possibleRoots = this.rulesOfWord[lexIndex];
        int i = 0;
        while (i < possibleRoots.length) {
            int ruleIndex = possibleRoots[i];
            int[] rule = this.lexRules[ruleIndex];
            if (rule[0] == rootIndex) {
                return this.lexLogProb[ruleIndex];
            }
            ++i;
        }
        return -1.0;
    }

    public double getUnaryLogProb(int rootIndex, int leftIndex) {
        int[] possibleRoots = this.unaryRulesOfLeftChild[leftIndex];
        int i = 0;
        while (i < possibleRoots.length) {
            int ruleIndex = possibleRoots[i];
            int[] rule = this.intUnaryRules[ruleIndex];
            if (rule[0] == rootIndex) {
                return this.intUnaryLogProb[ruleIndex];
            }
            ++i;
        }
        return -1.0;
    }

    public double getBinaryLogProb(int rootIndex, int leftIndex, int rightIndex) {
        int[] possibleRoots = this.binaryRulesOfLeftChild[leftIndex];
        int i = 0;
        while (i < possibleRoots.length) {
            int ruleIndex = possibleRoots[i];
            int[] rule = this.intBinaryRules[ruleIndex];
            if (rule[0] == rootIndex && rule[2] == rightIndex) {
                return this.intBinaryLogProb[ruleIndex];
            }
            ++i;
        }
        return -1.0;
    }
}

