/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser.petrov;

import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.ParserData;
import edu.stanford.nlp.parser.lexparser.PetrovLexiconFede;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.metrics.MetricOptimizerArray;
import tsg.parseEval.EvalB;
import tsg.parseEval.EvalC;
import util.FileUtil;
import util.Utility;
import wordModel.UkWordMapping;
import wordModel.UkWordMappingPetrov;

public class RunPetrovGrammarWithStanford
extends Thread {
    static UkWordMapping ukModel;
    static int nBest;
    static String topSymbol;
    static double minProbRule;
    static File petrovGrammarFile;
    static File petrovLexiconFile;
    static File outputDir;
    static int threads;
    static File trainTreebankFile;
    static File testTreebankFile;
    static int sentenceLengthLimitTest;
    String outputPath;
    File testTreebankFileClean;
    ArrayList<TSNodeLabel> originalTrainingTreebank;
    ArrayList<TSNodeLabel> trainingTreebank;
    ArrayList<TSNodeLabel> originalTestTreebank;
    ArrayList<TSNodeLabel> testTreebank;
    int testSize;
    File parsedFile;
    LexicalizedParser lp;

    @Override
    public void run() {
        this.outputPath = outputDir + "/" + "Parsing_" + FileUtil.dateTimeString() + "/";
        new File(this.outputPath).mkdir();
        Parameters.openLogFile(new File(String.valueOf(this.outputPath) + "log.txt"));
        this.outputParametersToLogFile();
        this.testTreebankFileClean = new File(String.valueOf(this.outputPath) + testTreebankFile.getName());
        this.getTrainingAndTestTreebanks();
        this.preprocessUnknownWords();
        try {
            this.buildGrammar();
            this.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.parseEval();
    }

    private void buildGrammar() throws FileNotFoundException {
        Parameters.reportLineFlush("Acquiring petrov grammar...");
        ParserData pd = LexicalizedParser.getParserDataFromPetrovFiles((String)petrovGrammarFile.toString(), (String)petrovLexiconFile.toString());
        Parameters.reportLineFlush("Finished Acquisition");
        this.lp = new LexicalizedParser(pd);
        this.lp.setGoalString(topSymbol);
    }

    private void parse() throws Exception {
        Parameters.reportLineFlush("Parsing Petrov with Stanford Parser using " + threads + " threads");
        Parameters.reportLineFlush("Parsing " + this.testSize + " sentences:");
        this.parsedFile = new File(String.valueOf(this.outputPath) + "parsedFile.mrg");
        PrintWriter pw = FileUtil.getPrintWriter(this.parsedFile);
        for (TSNodeLabel t : this.testTreebank) {
            String flatSentence = t.toFlatSentence();
            System.out.println("Parsing sentence: " + flatSentence);
            this.lp.parse(flatSentence);
            pw.println(this.lp.getBestParse().toString());
        }
        pw.close();
    }

    private void parseEval() {
        Parameters.reportLineFlush("Running EvalB and EvalC");
        DecimalFormat df = new DecimalFormat("0.00");
        File evalBfile = FileUtil.changeExtention(this.parsedFile, "evalB");
        File evalCfile = FileUtil.changeExtention(this.parsedFile, "evalC");
        new EvalB(this.testTreebankFileClean, this.parsedFile, evalBfile);
        EvalC eval = new EvalC(this.testTreebankFileClean, this.parsedFile, evalCfile, null, true);
        float[] results = eval.makeEval();
        Parameters.reportLineFlush(String.valueOf(Utility.fse(15, "MPD")) + ":\tRecall, Precision, Fscore (<=" + EvalC.CUTOFF_LENGTH + "):  [" + df.format(results[0]) + ", " + df.format(results[1]) + ", " + df.format(results[2]) + "]");
    }

    private void getTrainingAndTestTreebanks() {
        try {
            Parameters.reportLineFlush("Reading Traininig Treebank");
            this.trainingTreebank = TSNodeLabel.getTreebank(trainTreebankFile);
            int trainingSize = this.trainingTreebank.size();
            Parameters.reportLineFlush("Traininig Treebank Size: " + trainingSize);
            Parameters.reportLineFlush("Reading Test Treebank");
            this.testTreebank = TSNodeLabel.getTreebank(testTreebankFile, sentenceLengthLimitTest);
            TSNodeLabel.printTreebankToFile(this.testTreebankFileClean, this.testTreebank, false, false);
            this.testSize = this.testTreebank.size();
            Parameters.reportLineFlush("Test Treebank Size: " + this.testSize);
            this.originalTrainingTreebank = this.trainingTreebank;
            this.originalTestTreebank = this.testTreebank;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void preprocessUnknownWords() {
        Parameters.reportLineFlush("Processing Unknown Words with model: " + ukModel.getClass());
        Parameters.reportLineFlush("UK threshold: " + UkWordMapping.ukThreashold);
        ukModel.init(this.trainingTreebank, this.testTreebank);
        this.trainingTreebank = ukModel.transformTrainingTreebank();
        this.testTreebank = ukModel.transformTestTreebank();
        File transformedTrainingTreBankFile = new File(String.valueOf(this.outputPath) + "trainingTreebank_UK.mrg");
        File transformedTestTreBankFile = new File(String.valueOf(this.outputPath) + "testTreebank_UK.mrg");
        TSNodeLabel.printTreebankToFile(transformedTrainingTreBankFile, this.trainingTreebank, false, false);
        TSNodeLabel.printTreebankToFile(transformedTestTreBankFile, this.testTreebank, false, false);
        Parameters.reportLineFlush("Printed training treebank after unknonw word process to: " + transformedTrainingTreBankFile);
        Parameters.reportLineFlush("Printed test treebank after unknonw word process to: " + transformedTestTreBankFile);
    }

    private void outputParametersToLogFile() {
        Parameters.reportLine("PetrovGrammarWithStanford\n");
        Parameters.reportLine("nBest: " + nBest);
        Parameters.reportLine("topSymbol: " + topSymbol);
        Parameters.reportLine("sentenceLengthLimitTest: " + sentenceLengthLimitTest);
        Parameters.reportLine("minProbRule: " + minProbRule);
        Parameters.reportLine("petrovGrammarFile: " + petrovGrammarFile);
        Parameters.reportLine("petrovLexiconFile: " + petrovLexiconFile);
        Parameters.reportLine("trainTreebankFile: " + trainTreebankFile);
        Parameters.reportLine("testTreebankFile: " + testTreebankFile);
        Parameters.reportLineFlush("threads: " + threads);
    }

    public static void main(String[] args) throws Exception {
        RunPetrovGrammarWithStanford.main1(new String[]{"tmp/eng_sm6_readable.gr.grammar", "tmp/eng_sm6_readable.gr.lexicon", "tmp/", "/scratch/fsangati/CORPUS/WSJ/CONSTITUENCY/ORIGINAL_READABLE_CLEANED_TOP_SEMTAGSOFF/wsj-02-21.mrg", "/scratch/fsangati/CORPUS/WSJ/CONSTITUENCY/ORIGINAL_READABLE_CLEANED_TOP_SEMTAGSOFF/wsj-24.mrg", "2"});
    }

    public static void main1(String[] args) throws Exception {
        UkWordMapping.ukThreashold = 0;
        ukModel = new UkWordMappingPetrov();
        nBest = 1000;
        topSymbol = "ROOT-0";
        sentenceLengthLimitTest = 40;
        PetrovLexiconFede.minProbRule = 0.0;
        minProbRule = 0.0;
        MetricOptimizerArray.setLambdaValues(0.0, 2.0, 0.5);
        petrovGrammarFile = new File(args[0]);
        petrovLexiconFile = new File(args[1]);
        outputDir = new File(args[2]);
        trainTreebankFile = new File(args[3]);
        testTreebankFile = new File(args[4]);
        threads = Integer.parseInt(args[5]);
        new RunPetrovGrammarWithStanford().run();
    }
}

