from bs4 import BeautifulSoup
import asyncio
import multiprocessing
import json
import os
import sys
from typing import List, Dict

def extracting(html):
    """
    提取HTML中的文本内容，并将换行符替换为空格，然后使用BeautifulSoup解析HTML，
    从<body>标签中获取文本内容，如果没有<body>标签则从根节点中获取，最后将所有段落组合成一个列表返回。
    
    Args:
        html (str): HTML代码字符串，包含文本内容和其他元素。
    
    Returns:
        list[str]: 一个列表，每个元素是一个文本段落，包含换行符。
    """
    html = html.replace("\n", " ")
    soup = BeautifulSoup(html, 'html.parser')
    raw = soup.find('body')
    if raw:
        raw = raw.get_text("\n")
    else:
        raw = soup.get_text("\n")
    paragraphs = []
    for item in raw.split("\n"):
        item = item.strip()
        if not item:
            continue
        paragraphs.append(item)
    return paragraphs