import time
import os
import threading

import openai

lock = threading.Lock()


def trigger_change_model(model_str):
    with lock:
        os.system(f"./change_model.sh {model_str}")


def wrap_client_completion(real_client_completion):
    def f(client, **kwargs):
        while True:
            try:
                return real_client_completion(client, **kwargs)
            except (openai.NotFoundError, openai.APIConnectionError) as e:
                model_str = kwargs["model"]
                trigger_change_model(model_str)
                print(f"Tried to use {model_str}, but it was not found. Retrying...")
                time.sleep(30)

    return f
