import os
import re

from .openai_utils import chatgpt_zero_shot_classification, join_hist


def is_ice_breaker(message):

    prompt = f""" We are here in the context of a negotiation.
    Definition:  A GOOD ICE BREAKER MAKES NO MENTION OF ANYTHING RELATED TO THE PURCHASE.
    classify this text as an ice breaker or not: {message}  
    Answer only with True or False."""
    edit = chatgpt_zero_shot_classification(
        messages=[
            {"role": "system", "content": prompt},
        ],
    )
    return re.sub(r"\b(?!True|False)\w+\b", "", edit)
