/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Filter;
import java.util.regex.Pattern;

public class RegexStringFilter
implements Filter<String> {
    final Pattern pattern;

    public RegexStringFilter(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public boolean accept(String text) {
        return this.pattern.matcher(text).matches();
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RegexStringFilter)) {
            return false;
        }
        return ((RegexStringFilter)other).pattern.equals(this.pattern);
    }
}

