/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasLemma;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import java.util.ArrayList;

public class TreeLemmatizer
implements TreeTransformer {
    @Override
    public Tree transformTree(Tree t) {
        Morphology morphology = new Morphology();
        ArrayList<TaggedWord> tagged = null;
        int index = 0;
        for (Tree leaf : t.getLeaves()) {
            String tag;
            Label label = leaf.label();
            if (label == null) continue;
            if (!(label instanceof HasTag) || ((HasTag)((Object)label)).tag() == null) {
                if (tagged == null) {
                    tagged = t.taggedYield();
                }
                tag = ((TaggedWord)tagged.get(index)).tag();
            } else {
                tag = ((HasTag)((Object)label)).tag();
            }
            if (!(label instanceof HasLemma)) {
                throw new IllegalArgumentException("Got a tree with labels which do not support lemma");
            }
            ((HasLemma)((Object)label)).setLemma(morphology.lemma(label.value(), tag, true));
            ++index;
        }
        return t;
    }
}

