theory question_11_4

imports Main

begin

typedecl entity
typedecl event

consts
  Many :: "entity ⇒ bool"
  Appliances :: "entity ⇒ bool"
  OneOutlet :: "entity ⇒ bool"
  Plugging :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Instrument :: "event ⇒ entity ⇒ bool"
  Location :: "event ⇒ entity ⇒ bool"
  SameCircuit :: "entity ⇒ event ⇒ bool"
  Dangerous :: "event ⇒ bool"
  Safe :: "event ⇒ bool"

(* Explanation 1: Plugging many appliances into one outlet, with the same electrical circuit, is a dangerous situation. *)
axiomatization where
  explanation_1: "∀x y z e. Many x ∧ Appliances y ∧ OneOutlet z ∧ Plugging e ∧ Agent e x ∧ Instrument e y ∧ Location e z ∧ SameCircuit z e ⟶ Dangerous e"

(* Explanation 2: A dangerous situation implies the absence of safety. *)
axiomatization where
  explanation_2: "∀e. Dangerous e ⟶ ¬ Safe e"

(* Explanation 3: A dangerous situation due to plugging many appliances into one outlet implies the absence of safety. *)
axiomatization where
  explanation_3: "∀x y z e. Many x ∧ Appliances y ∧ OneOutlet z ∧ Plugging e ∧ Agent e x ∧ Instrument e y ∧ Location e z ⟶ (Dangerous e ⟶ ¬ Safe e)"

theorem hypothesis:
  assumes asm: "Many x ∧ Appliances y ∧ OneOutlet z ∧ Plugging e ∧ Agent e x ∧ Instrument e y ∧ Location e z"
  (* Hypothesis: Plugging many appliances into one outlet is not a way to stay safe around electricity. *)
  shows "¬ Safe e"
proof -
  from asm have danger: "Dangerous e" using explanation_1 by blast
  then have "¬ Safe e" using explanation_2 by blast
  show ?thesis using danger by blast
qed

end
