theory question_11_10
imports Main

begin

typedecl entity
typedecl event

consts
  Appliances :: "entity ⇒ bool"
  Many :: "entity ⇒ bool"
  Outlet :: "entity ⇒ bool"
  ElectricalCircuit :: "entity ⇒ bool"
  Plugging :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  SameCircuit :: "entity ⇒ entity ⇒ bool"
  Dangerous :: "event ⇒ bool"
  Safety :: "entity ⇒ bool"

(* Explanation 1: Plugging many appliances into one outlet(o), with the same electrical circuit(c), is a dangerous situation(p) regarding electricity handling(h). *)
axiomatization where
  explanation_1: "∀x y z o c p. Appliances x ∧ Many y ∧ Outlet o ∧ ElectricalCircuit c ∧ Plugging p ∧ Agent p x ∧ Patient p o ∧ SameCircuit c o ⟶ Dangerous p"

(* Explanation 2: A dangerous situation(p) implies the absence of safety(s). *)
axiomatization where
  explanation_2: "∀p s. Dangerous p ⟶ ¬Safety s"

theorem hypothesis:
  assumes asm: "Appliances x ∧ Many y ∧ Outlet o ∧ ElectricalCircuit c ∧ Plugging p ∧ Agent p x ∧ Patient p o ∧ SameCircuit c o"
  (* Hypothesis: Plugging many appliances into one outlet(o), with the same electrical circuit(c), is not a way to stay safe around electricity(e). *)
  shows "¬Safety e"
proof -
  from asm have danger: "Dangerous p" using explanation_1 by blast
  then have "¬Safety s" using explanation_2 by blast
  then show "¬Safety e" by simp
qed

end
