theory question_44_0
imports Main

begin

typedecl entity
typedecl event

consts
  Vanes :: "entity ⇒ bool"
  ElectricFan :: "entity ⇒ bool"
  Rotating :: "entity ⇒ event ⇒ bool"
  Move :: "entity ⇒ event ⇒ bool"
  Air :: "entity ⇒ bool"
  Nitrogen :: "entity ⇒ bool"
  Oxygen :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Movement :: "event ⇒ entity ⇒ bool"

(* Explanation 1: the vanes rotating in an electric fan causes air to move *)
axiomatization where
  explanation_1: "∀x y e1 e2. Vanes x ∧ ElectricFan y ∧ Rotating x e1 ⟶ Move y e2"

(* Explanation 2: Air is mostly nitrogen and oxygen. *)
axiomatization where
  explanation_2: "∀x. Air x ⟶ (∃y z. Nitrogen y ∧ Oxygen z ∧ PartOf y x ∧ PartOf z x)"

theorem hypothesis:
  assumes asm: "Vanes e1 ∧ ElectricFan e2 ∧ Rotating e1 e2 ∧ Air z ∧ Nitrogen x ∧ Oxygen y"
  (* Hypothesis: Nitrogen and oxygen move because of vanes rotating in an electric fan. *)
  shows "∃e3. Movement e3 x  ∧ Movement e3 y "
proof -
  from asm have "Rotating e1 e2" by simp
  then have "Move e2 e3" using explanation_1 by blast
  then have "Nitrogen x ∧ Oxygen y ∧ PartOf x e3 ∧ PartOf y e3" using explanation_2 by blast
  then have "Movement e3 x" by simp
  then have "Movement e3 y" by simp
  then show ?thesis using asm by blast
qed

end
