theory question_98_8

imports Main

begin

typedecl entity
typedecl event
typedecl possibleWorld

consts
  Event :: "event ⇒ bool"
  PossibleWorld :: "possibleWorld ⇒ bool"
  Man :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  OutOf :: "event ⇒ entity ⇒ entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  CanJumpInto :: "entity ⇒ bool"
  CanJumpOutOf :: "entity ⇒ bool"
  Manifestation :: "event ⇒ (entity ⇒ entity ⇒ bool) ⇒ bool"
  Involves :: "event ⇒ entity ⇒ bool"
  YoungMan :: "entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Splashing :: "event ⇒ entity ⇒ bool"
  Water :: "entity"
  Same :: "entity ⇒ entity ⇒ bool"
  Everywhere :: "entity ⇒ bool"

(* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
assumes asm: "YoungMan x ∧ Goggles y ∧ Wearing x y ∧ Pool z ∧ Jumping e ∧ Agent e x ∧ OutOf e x z ∧ Splashing e Water ∧ Everywhere Water"

(* Hypothesis: Man jumping out of a pool. *)
shows "∃x e. Man x ∧ Pool e ∧ Jumping e ∧ Agent e x ∧ OutOf e x x"

(* Explanation 1: A man jumping out of a pool is an event in the possible world, where the pool is an entity that can be jumped into and out of. *)
axiomatization where
  explanation_1: "∀w e x. Event e ∧ PossibleWorld w ∧ Man x ∧ Pool e ∧ Jumping e ∧ Agent e x ∧ OutOf e x e ⟶ Entity e ∧ CanJumpInto e ∧ CanJumpOutOf e"

(* Explanation 2: An event of a man jumping out of a pool is a manifestation of the man jumping out of the pool entity, and this event involves the man and the pool. *)
axiomatization where
  explanation_2: "∀e x y. Event e ∧ Man x ∧ Pool y ∧ Jumping e ∧ Agent e x ∧ OutOf e x y ⟶ Manifestation e (Jumping x y) ∧ Involves e x ∧ Involves e y"

(* Explanation 3: A young man wearing goggles, who jumps out of a pool, splashing water everywhere, is the same man who is jumping out of the pool. *)
axiomatization where
  explanation_3: "∃x e y z. YoungMan x ∧ Goggles y ∧ Wearing x y ∧ Pool z ∧ Jumping e ∧ Agent e x ∧ OutOf e x z ∧ Splashing e Water ∧ Same x (SOME x. YoungMan x ∧ Pool z ∧ Jumping e ∧ Agent e x ∧ OutOf e x z)"

qed

end
