theory question_85_9
imports Main

begin

typedecl entity
typedecl event

consts
  PacinianCorpuscles :: "entity ⇒ bool"
  SpecificTypeOf :: "entity ⇒ entity ⇒ bool"
  PressureReceptorsEntity :: "entity"
  PressureReceptors :: "entity ⇒ bool"
  SharesAllLocationProperties :: "entity ⇒ entity ⇒ bool"
  MainlyFoundIn :: "entity ⇒ entity ⇒ bool"
  Skin :: "entity"

(* Explanation 1: Pacinian corpuscles are a specific type of pressure receptors. *)
axiomatization where
  explanation_1: "∀x. PacinianCorpuscles x ⟶ SpecificTypeOf x PressureReceptorsEntity"

(* Explanation 2: If an entity is a specific type of another entity, it shares all the location properties with that entity. *)
axiomatization where
  explanation_2: "∀x y. SpecificTypeOf x y ⟶ SharesAllLocationProperties x y"

(* Explanation 3: Pressure receptors are mainly found in the skin. *)
axiomatization where
  explanation_3: "∀x. PressureReceptors x ⟶ MainlyFoundIn x Skin"

(* Explanation 4: If two entities share all the location properties, then they are mainly found in the same locations. *)
axiomatization where
  explanation_4: "∀x y. SharesAllLocationProperties x y ⟶ (∃z. MainlyFoundIn x z ∧ MainlyFoundIn y z)"

(* Definition: PressureReceptors x holds iff x is a pressure receptor *)
definition PressureReceptors_def :: "entity ⇒ bool" where
  "PressureReceptors_def x ≡ SpecificTypeOf x PressureReceptorsEntity"

(* Theorem: Pacinian corpuscles are mainly found in the skin *)
theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "MainlyFoundIn x Skin"
proof -
  from asm have "PacinianCorpuscles x" by simp
  then have "SpecificTypeOf x PressureReceptorsEntity" using explanation_1 by blast
  then have "SharesAllLocationProperties x PressureReceptorsEntity" using explanation_2 by blast
  then obtain z where "MainlyFoundIn x z" and "MainlyFoundIn PressureReceptorsEntity z" using explanation_4 by blast
  then have "PressureReceptorsEntity z" using explanation_3 by blast
  then have "MainlyFoundIn x Skin" using that by blast
  then show ?thesis by simp
qed

end
