theory question_67_3
imports Main

begin
typedecl entity
typedecl event

consts
  RiverBoatTour :: "entity ⇒ bool"
  BoatTour :: "entity ⇒ bool"
  RiverBoat :: "entity ⇒ bool"
  Boat :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"
  Older :: "entity ⇒ bool"
  SittingTogether :: "entity ⇒ entity ⇒ entity ⇒ bool"
  Boat_ :: "entity ⇒ bool"

(* Explanation 1: A river boat tour is a type of boat tour. *)
axiomatization where
  explanation_1: "∀x. RiverBoatTour x ⟶ BoatTour x"

(* Explanation 2: A river boat is a boat. *)
axiomatization where
  explanation_2: "∀x. RiverBoat x ⟶ Boat x"

(* Explanation 3: Two males sitting together on a boat *)
axiomatization where
  explanation_3: "∀x y z. Male x ∧ Male y ∧ x ≠ y ∧ Boat_ z ∧ SittingTogether x y z ⟶ [∃x' y'. Male x' ∧ Male y' ∧ x' ≠ y' ∧ Boat z ∧ SittingTogether x' y' z]"

theorem hypothesis:
  (* Premise: Two older males sitting together on a river boat tour. *)
  assumes asm: "Male x ∧ Male y ∧ x ≠ y ∧ Older x ∧ Older y ∧ RiverBoatTour z ∧ BoatTour z ∧ SittingTogether x y z"
  (* Hypothesis: Two males sitting together on a boat *)
  shows "∃x y. Male x ∧ Male y ∧ x ≠ y ∧ Boat_ z ∧ SittingTogether x y z"
proof -
  from asm have "Male x" by blast
  from asm have "Male y" by blast
  from asm have "x ≠ y" by blast
  from asm have "RiverBoatTour z" by blast
  from this have "Boat z" using explanation_2 by blast
  from asm have "SittingTogether x y z" by blast
  show ?thesis using `Male x` `Male y` `x ≠ y` `Boat z` `SittingTogether x y z` by blast
qed

end
