theory question_49_6

imports Main

begin

typedecl entity
typedecl event

consts
  Puddle :: "entity ⇒ bool"
  SunCameOut :: "entity ⇒ bool"
  Disappeared :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: The puddle disappeared when the sun came out. *)
axiomatization where
  explanation_1: "∀x y e. Puddle x ∧ SunCameOut y ∧ Disappeared e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: at 10 a.m. the sun is shining on a puddle of water on the road. *)
  assumes asm: "SunShining x ∧ PuddleOfWater y ∧ Road e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: The water evaporated. *)
  shows "∃x. Water x  ∧ Evaporated x "
proof -
  from asm have "SunShining x ∧ PuddleOfWater y ∧ Road e ∧ Agent e x ∧ Patient e y" by simp
  then obtain e1 where e1: "Disappeared e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_1 by blast
  then have "Puddle x" using e1 by simp
  show ?thesis using asm e1 by blast
qed

end
