theory question_60_0

imports Main

begin

typedecl entity
typedecl event
consts
  Boy :: "entity ⇒ bool"
  KarateForm :: "entity ⇒ bool"
  Uniform :: "entity ⇒ bool"
  Pose :: "event ⇒ bool"
  Show :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A boy poses in karate form and uniform means the boy shows "his uniform. *)"
axiomatization where
  explanation_1: "∀x y e. Boy x ∧ KarateForm y ∧ Uniform e ∧ Pose e ∧ Show e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A boy poses in karate form and uniform. *)
  assumes asm: "Boy x ∧ KarateForm y ∧ Uniform e ∧ Pose e ∧ Show e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A boy shows "his uniform. *)"
  shows "∃x e. Boy x ∧ Uniform e ∧ Showing e ∧ Agent e x"
proof -
  from asm have "Boy x" by blast
  from this have "Uniform e" using explanation_1 by blast
  from asm have "Pose e" by blast
  from asm have "Show e" by blast
  show ?thesis using `Boy x` `Uniform e` `Pose e` `Show e` by blast
qed

end
