theory question_54_7

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  PlayingTennis :: "event ⇒ bool"
  AboutToStrike :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  WearingRedAndBlack :: "entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A man playing tennis is about to strike a tennis ball. *)
axiomatization where
  explanation_1: "∃x e. Man x ∧ PlayingTennis e ∧ AboutToStrike e ∧ Agent e x"

theorem hypothesis:
  (* Premise: A man in red and black about to strike a tennis ball. *)
  assumes asm: "Man x ∧ WearingRedAndBlack x ∧ AboutToStrike e ∧ Agent e x ∧ Patient e TennisBall"
  (* Hypothesis: A man is playing tennis. *)
  shows "∃x e. Man x ∧ PlayingTennis e ∧ Agent e x"
proof -
  from asm have "Man x" by blast
  from this have "PlayingTennis e" using explanation_1 by blast
  show ?thesis using `Man x` `PlayingTennis e` by blast
qed

end
