theory question_65_5
imports Main
begin

typedecl entity
typedecl event

consts
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  FlowsThrough :: "event ⇒ bool"
  Circuit :: "event ⇒ bool"
  Reach :: "event ⇒ entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Electricity :: "event ⇒ bool"
  Flow :: "event ⇒ bool"
  Through :: "event ⇒ event ⇒ bool"
  Eventually :: "event ⇒ entity ⇒ bool"
  InteractsWith :: "event ⇒ bool"
  Filament :: "entity ⇒ bool"
  Inside :: "entity ⇒ bool"
  Interact :: "event ⇒ bool"
  Cause :: "event ⇒ bool"
  EmitLight :: "event ⇒ bool"
  Light :: "event ⇒ bool"
  Emit :: "event ⇒ bool"
  Emission :: "event ⇒ bool"
  Perceived :: "event ⇒ bool"
  ComingOn :: "event ⇒ bool"
  PerceivedAs :: "event ⇒ entity ⇒ bool"
  ResultsIn :: "event ⇒ event ⇒ bool"

(* Explanation 1: When a switch in a simple series circuit is closed, electricity flows through the circuit, eventually reaching the light bulb. *)
axiomatization where
  explanation_1: "∀e1 e2 x y z. Switch x ∧ SimpleSeriesCircuit y ∧ Closed e1 ∧ FlowsThrough e2 ∧ Circuit e2 ∧ Reach e2 LightBulb ⟶ (Electricity e1 ∧ Flow e1 ∧ Through e1 e2 ∧ Eventually e2 LightBulb)"

(* Explanation 2: When electricity reaches the light bulb, it interacts with the filament inside. *)
axiomatization where
  explanation_2: "∀e x y. Electricity e ∧ Reach e LightBulb x ∧ InteractsWith e ∧ Filament y ∧ Inside y"

(* Explanation 3: The interaction between electricity and the filament causes the light bulb to emit light. *)
axiomatization where
  explanation_3: "∀e1 e2 x y z. Electricity e1 ∧ Filament y ∧ LightBulb z ∧ Interact e1 ∧ Cause e2 ∧ EmitLight e2 ⟶ (LightBulb e2 ∧ Emit e2)"

(* Explanation 4: The emission of light from the light bulb is perceived as the light coming on. *)
axiomatization where
  explanation_4: "∀e1 e2 x y. Emission e1 ∧ Light e1 ∧ Perceived e2 ∧ ComingOn e2 ⟶ (PerceivedAs e2 Light ∧ ComingOn e2)"

(* Explanation 5: The emission of light from the light bulb results in the light actually coming on. *)
axiomatization where
  explanation_5: "∀e1 e2 x y. Emission e1 ∧ Light e1 ∧ ResultsIn e2 ComingOn e2 ⟶ (Light e2 ∧ ComingOn e2)"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃e x y. Electricity e ∧ Flow e ∧ Through e x ∧ Reach e LightBulb y ∧ ComingOn e ∧ Light e "
proof -
  from asm have "Electricity e ∧ Flow e ∧ Through e x ∧ Eventually e LightBulb y" using explanation_1 by blast
  then obtain z where z: "InteractsWith e ∧ Filament z ∧ Inside z" using explanation_2 by blast
  then obtain e' where e': "Interact e' ∧ Cause e' ∧ EmitLight e'" using explanation_3 z by blast
  then obtain e'' where e'': "Emission e' ∧ Light e' ∧ Perceived e'' ∧ ComingOn e''" using explanation_4 by blast
  then have "Light e'' ∧ ComingOn e''" using explanation_5 e'' by blast
  show ?thesis using asm z e' e'' by blast
qed

end
