theory question_23_5

imports Main

begin

typedecl entity
typedecl event

consts
  Hurricanes :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"
  HighWindSpeeds :: "event ⇒ bool"
  Exhibit :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Hurricanes and tornadoes consistently exhibit high wind speeds. *)
axiomatization where
  explanation_1: "∀x. (Hurricanes x ∨ Tornadoes x) ⟶ (∃e. HighWindSpeeds e ∧ Exhibit e x)"

theorem hypothesis:
  assumes asm: "Hurricanes x ∨ Tornadoes x"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃e. HighWindSpeeds e ∧ Exhibit e x"
proof -
  from asm have "Hurricanes x ∨ Tornadoes x" by simp
  then obtain e where e: "HighWindSpeeds e ∧ Exhibit e x" using explanation_1 by blast
  then show ?thesis using e by blast
qed

end
