theory question_77_4
imports Main

begin
typedecl entity
typedecl event

consts
  GoldenColoredDog :: "entity ⇒ bool"
  LightColoredFur :: "entity ⇒ bool"
  Dog :: "entity ⇒ bool"
  LightColored :: "entity ⇒ bool"
  AlertEyes :: "entity ⇒ bool"
  Holds :: "entity ⇒ entity ⇒ bool"
  BrightlyColoredTennisBall :: "entity ⇒ bool"

(* Explanation 1: A golden-colored dog typically has light-colored fur. *)
axiomatization where
  explanation_1: "∀x. GoldenColoredDog x ⟶ LightColoredFur x"

theorem hypothesis:
  (* Premise: A golden-colored dog, with his eyes alert, holds a brightly colored tennis ball in his mouth. *)
  assumes asm: "GoldenColoredDog x ∧ AlertEyes x ∧ Holds x x BrightlyColoredTennisBall x "
  (* Hypothesis: The dog is light colored. *)
  shows "∃x. Dog x ∧ LightColored x"
proof -
  from asm have "GoldenColoredDog x" by blast
  from this and explanation_1 have "LightColored x" by blast
  then show ?thesis using asm by blast
qed

end
