theory question_24_0

imports Main

begin
typedecl entity
typedecl event

consts
  CuteCouple :: "entity ⇒ bool"
  Club :: "entity ⇒ bool"
  Couple :: "entity ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A cute couple at a club means a couple is at a club. *)
axiomatization where
  explanation_1: "∀x y z. CuteCouple x ∧ Club y ⟶ Couple x ∧ At x y"

(* Hypothesis 1: The couple is at a club. *)
axiomatization where
  hypothesis_1: "∃x y e. Couple x ∧ Club y ∧ At x y"

theorem hypothesis:
  (* Premise: The couple is at a club. *)
  assumes asm: "Couple x ∧ Club y ∧ At x y"
  (* Hypothesis: The couple is at a club. *)
  shows "∃x y e. Couple x ∧ Club y ∧ At x y"
proof -
  from asm have "Couple x ∧ Club y" by blast
  then have "CuteCouple x ∧ Club y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
