import glob
import json, os, sys
from tqdm import tqdm
from utils.html_utils import *
from module.reflextion_crawler import AutoCrawler
from module.prompt import *
from run_swde.task_prompt import swde_prompt
from lxml import html

def get_max_depth(element, current_depth=0):
    """
    递归函数，用于获取元素的最大深度。
    """
    max_depth = current_depth
    for child in element:
        child_depth = get_max_depth(child, current_depth + 1)
        if child_depth > max_depth:
            max_depth = child_depth
    return max_depth

SCHEMA = {
    'auto': ['model', 'price', 'engine', 'fuel_economy'],
    'book': ['title', 'author', 'isbn_13', 'publisher', 'publication_date'],
    'camera': ['model', 'price', 'manufacturer'],
    'job': ['title', 'company', 'location', 'date_posted'],
    'movie': ['title', 'director', 'genre', 'mpaa_rating'],
    'nbaplayer': ['name', 'team', 'height', 'weight'],
    'restaurant': ['name', 'address', 'phone', 'cuisine'],
    'university': ['name', 'phone', 'website', 'type']
}

DATA_HOME = '/mnt/data122/harryhuang/swde/sourceCode'

web_len_split = {'0': [],
             '1': [],
             '2': [],
             '3': []}
web_len = []

for field in SCHEMA.keys():
    for website_path in glob.glob(os.path.join(DATA_HOME, field, '*')):
        website_name = website_path.split('/')[-1].split('(')[0]
        print(website_name)
        webpage_list = glob.glob(os.path.join(website_path, '*'))
        
        xpath_rule = {}
        sorted(webpage_list)

        web_length = 0
        result_list = []
        for webpage in tqdm(webpage_list[:100]):
            web_index = webpage.split('/')[-1].replace('.htm','')

            with open(webpage, 'r') as f:
                html_content = simplify_html(f.read())
            root = html.fromstring(html_content)
            web_length += get_max_depth(root)

        web_len.append((website_name, web_length / 100))

web_len = sorted(web_len, key=lambda x: x[1])
for web in web_len[:20]:
    web_len_split['0'].append(web)
for web in web_len[20:40]:
    web_len_split['1'].append(web)
for web in web_len[40:60]:
    web_len_split['2'].append(web)
for web in web_len[60:80]:
    web_len_split['3'].append(web)



        # if web_length // 1000000 == 0:
        #     web_len_split['0'].append(website_name)
        # elif web_length // 1000000 == 1:
        #     web_len_split['1'].append(website_name)
        # elif web_length // 1000000 == 2:
        #     web_len_split['2'].append(website_name)
        # elif web_length // 1000000 == 3:
        #     web_len_split['3'].append(website_name)
        # elif web_length // 1000000 == 4:
        #     web_len_split['4'].append(website_name)
        # else:
        #     web_len_split['5+'].append(website_name)
with open('run_swde_depth.json', 'w') as f:
    json.dump(web_len_split, f, ensure_ascii=False, indent=4) 
    