import re, string, os
from collections import defaultdict, Counter

def normalize_answer_hotpot(s):
  def remove_articles(text):
    return re.sub(r"\b(a|an|the)\b", " ", text)
  
  def white_space_fix(text):
      return " ".join(text.split())

  def remove_punc(text):
      exclude = set(string.punctuation)
      return "".join(ch for ch in text if ch not in exclude)

  def lower(text):
      return text.lower()
  if s ==None:
      return None
  return white_space_fix(remove_articles(remove_punc(lower(s))))
def grade_answer_hotpot(answer, gold):
    return normalize_answer_hotpot(answer) == normalize_answer_hotpot(gold)
def parse_action_hotpot(text):
    pattern = r'^(\w+)\[(.+)\]$'
    match = re.match(pattern, text)
    
    if match:
        action_type = match.group(1)
        argument = match.group(2)
        return action_type, argument
    else:
        return "Incorrect Format", text
def parse_answer_noreact_hotpot(text):
    idx = text.rfind("[")
    if idx < 0:
        return None, None
    i = idx
    right_brace_idx = None
    num_left_braces_open = 0
    while i < len(text):
        if text[i] == "[":
            num_left_braces_open += 1
        if text[i] == "]":
            num_left_braces_open -= 1
            if num_left_braces_open == 0:
                right_brace_idx = i
                break
        i += 1
    if right_brace_idx == None:
        retval = None
    else:
        retval = text[idx+1:right_brace_idx]
    return None, retval