import argparse
import pathlib
import re
import shutil

parser = argparse.ArgumentParser()
parser.add_argument('--workspaces', nargs='+', type=pathlib.Path, required=True)
parser.add_argument('--hidden-layer-sizes', type=int, nargs='+', default=[100, 100])
parser.add_argument('--activation', default='logistic')
parser.add_argument('--max-iter', default=500)


classification_method_re = re.compile(r'^CLASSIFICATION_METHOD\s*=')

def process_workspace(args, workspace):
    # Edit configuration file
    lines = (workspace / 'conf' / 'conf.py').read_text().splitlines()
    matched_lineno = -1
    for i, line in enumerate(lines):
        m = classification_method_re.match(line)
        if m:
            matched_lineno = i
    if matched_lineno != -1:
        lines[matched_lineno] = 'CLASSIFICATION_METHOD = \'mlp\''
    else:
        lines.append('CLASSIFICATION_METHOD = \'mlp\'')
    with open(workspace / 'conf' / 'conf.py', 'w') as f:
        for line in lines:
            print(line, file=f)

    # Save classififier configuration
    p = workspace / 'conf' / f'mlp.py'
    with open(p, 'w') as f:
        print('KEYWORDS = {', file=f)
        print(f'    \'hidden_layer_sizes\': {args.hidden_layer_sizes!r},', file=f)
        print(f'    \'activation\': \'{args.activation}\',', file=f)
        print(f'    \'max_iter\': {args.max_iter},', file=f)
        print('}', file=f)
    shutil.copy(p, workspace / 'conf' / 'classifier_hyperparams.py')


def run(args):
    for workspace in args.workspaces:
        process_workspace(args, workspace)


if __name__ == '__main__':
    args = parser.parse_args()
    run(args)
