-- This module will transliterate Macedonian language text per WT:MK TR.
local export = {}
 
local tt = {
	["А"]='A', ["а"]='a',
	["Б"]='B', ["б"]='b',
	["В"]='V', ["в"]='v',
	["Г"]='G', ["г"]='g',
	["Ѓ"]='Ǵ', ["ѓ"]='ǵ', 
	["Д"]='D', ["д"]='d',
	["Е"]='E', ["е"]='e', ["Ѐ"]='È', ["ѐ"]='è',
	["Ж"]='Ž', ["ж"]='ž',
	["З"]='Z', ["з"]='z',
	["Ѕ"]='Dz', ["ѕ"]='dz', 
	["И"]='I', ["и"]='i', ["Ѝ"]='Ì', ["ѝ"]='ì',
	["Ј"]='J', ["ј"]='j',
	["К"]='K', ["к"]='k',
	["Л"]='L', ["л"]='l',
	["Љ"]='Lj', ["љ"]='lj', 
	["М"]='M', ["м"]='m',
	["Н"]='N', ["н"]='n',
	["Њ"]='Nj', ["њ"]='nj',
	["О"]='O', ["о"]='o',
	["П"]='P', ["п"]='p', 
	["Р"]='R', ["р"]='r',
	["С"]='S', ["с"]='s',
	["Т"]='T', ["т"]='t',
	["Ќ"]='Ḱ', ["ќ"]='ḱ',
	["У"]='U', ["у"]='u', 
	["Ф"]='F', ["ф"]='f',
	["Х"]='H', ["х"]='h',
	["Ц"]='C', ["ц"]='c',
	["Ч"]='Č', ["ч"]='č',
	["Џ"]='Dž', ["џ"]='dž', 
	["Ш"]='Š', ["ш"]='š',
};

function export.tr(text, lang, sc)
	return (mw.ustring.gsub(text, '.', tt))
end

return export