-- This module will transliterate Karakalpak language text per WT:KAA TR.

local export = {}

local tt = {
	["ү"]="ü",['Ү']='Ü',   ["т"]="t",['Т']='T', ["Ў"]="W",['ў']='w', ["р"]="r",['Р']='R',   ["ф"]="f",['Ф']='F',
	["ю"]="yu",['Ю']='Yu', ["ш"]="ş",['Ш']='Ş', ["ь"]="ʹ",['Ь']='ʹ',   ["ъ"]="ʺ",['Ъ']='ʺ', ["н"]="n",['Н']='N', 
	["п"]="p",['П']='P',   ["й"]="y",['Й']='Y', ["л"]="l",['Л']='L',   ["з"]="z",['З']='Z', ["е"]="e",['Е']='E', 
	["г"]="g",['Г']='G',   ["б"]="b",['Б']='B', ["у"]="u",['У']='U',   ["с"]="s",['С']='S', ["х"]="h",['Х']='H',
	["ч"]="ç",['Ч']='Ç', ["щ"]="şç",['Щ']='Şç', ["я"]="ya",['Я']='Ya', ["ы"]="ı",['Ы']='I', ["э"]="e",['Э']='E', 
	["м"]="m",['М']='M',   ["о"]="o",['О']='O', ["и"]="i",['И']='I', ["ё"]="yo",['Ё']='Yo', ["ж"]="j",['Ж']='J',
	["к"]="k",['К']='K',   ["д"]="d",['Д']='D', ["в"]="v",['В']='V', ["ц"]="ts",['Ц']='Ts', ["а"]="a",['А']='A',
	["ң"]="ñ",['Ң']='Ñ',   ["ә"]="ä",['Ә']='Ä', ["э"]="é",['Э']='É', ["қ"]="q",['Қ']="Q",
	["ғ"]="ğ",['Ғ']='Ğ',   ["ө"]="ö",['Ө']='Ö'
};

function export.tr(text)
	return (mw.ustring.gsub(text, '.', tt))
end

return export