-- This module will transliterate Adyghe language text per WT:ADY TR.

-- 	Text	Expected	Actual
-- Passed	ахъчэзэблэхъущ	āχčăzăblăχ°š̍	āχčăzăblăχ°š̍
-- Passed	ахъчэжъгъэй	āχčăẑġăj	āχčăẑġăj
-- Passed	бгъотагъэ	bġotāġă	bġotāġă
-- Passed	бгъунджырыкӏу	bġ°nǯ̍ərəḳ°	bġ°nǯ̍ərəḳ°
-- Passed	бгъунджырыкӀу	bġ°nǯ̍ərəḳ°	bġ°nǯ̍ərəḳ°
-- Passed	бгъэхэӏушъхь	bġăxăʾ°ŝḥ	bġăxăʾ°ŝḥ
-- Passed	бгъэхэӀушъхь	bġăxăʾ°ŝḥ	bġăxăʾ°ŝḥ
-- Passed	былъытырыкӏу	bəłətərəḳ°	bəłətərəḳ°
-- Passed	былъытырыкӀу	bəłətərəḳ°	bəłətərəḳ°
-- Passed	гъогурыгъуазэ	ġog°rəġ°āză	ġog°rəġ°āză
-- Passed	жъогъо шӏӏэныгъэлӏ	ẑoġo ṣ̂ʾănəġăḷ	ẑoġo ṣ̂ʾănəġăḷ
-- Passed	жъогъо шӀӀэныгъэлӀ	ẑoġo ṣ̂ʾănəġăḷ	ẑoġo ṣ̂ʾănəġăḷ
-- Passed	жьыкъыдэгъэкӏын	ž̍əqədăġăč̣̍ən	ž̍əqədăġăč̣̍ən
-- Passed	жьыкъыдэгъэкӀын	ž̍əqədăġăč̣̍ən	ž̍əqədăġăč̣̍ən
-- Passed	къэкӏорэтхьэмафэ	qăč̣̍orătḥămāfă	qăč̣̍orătḥămāfă
-- Passed	къэкӀорэтхьэмафэ	qăč̣̍orătḥămāfă	qăč̣̍orătḥămāfă
-- local function add_uppercase_palochka(examples)
-- 	local out = {}
-- 	local i = 0
-- 	local lowercase_palochka, uppercase_palochka = mw.ustring.char(0x4CF), mw.ustring.char(0x4C0)
-- 	for _, example in ipairs(examples) do
-- 		i = i + 1
-- 		out[i] = example
-- 		if example[1]:find(lowercase_palochka) then
-- 			i = i + 1
-- 			out[i] = { example[1]:gsub(lowercase_palochka, uppercase_palochka), example[2] }
-- 		end
-- 	end
-- 	return out
-- end

-- return require("Module:transliteration module testcases")(
-- 	require("Module:ady-translit").tr,
-- 	add_uppercase_palochka{
-- 		{ "ахъчэзэблэхъущ", "āχčăzăblăχ°š̍" },
-- 		{ "ахъчэжъгъэй", "āχčăẑġăj" },
-- 		{ "бгъотагъэ", "bġotāġă" },
-- 		{ "бгъунджырыкӏу", "bġ°nǯ̍ərəḳ°" },
-- 		{ "бгъэхэӏушъхь", "bġăxăʾ°ŝḥ" },
-- 		{ "былъытырыкӏу", "bəłətərəḳ°" },
-- 		{ "гъогурыгъуазэ", "ġog°rəġ°āză" },
-- 		{ "жъогъо шӏӏэныгъэлӏ", "ẑoġo ṣ̂ʾănəġăḷ" },
-- 		{ "жьыкъыдэгъэкӏын", "ž̍əqədăġăč̣̍ən" },
-- 		{ "къэкӏорэтхьэмафэ", "qăč̣̍orătḥămāfă" },
-- 		--[[
-- 		{ "", "" },
-- 		--]]
-- 	},
-- 	"Cyrl", "ady"
-- )

local export = {}

local tt = {
	["а"]="ā", ["б"]="b", ["в"]="v", ["г"]="ɣ", ["д"]="d", ["е"]="e", ["ё"]="ë", ["ж"]="ž",
	["з"]="z", ["и"]="i", ["й"]="j", ["к"]="k", ["л"]="l", ["м"]="m", ["н"]="n", ["о"]="o", 
	["п"]="p", ["р"]="r", ["с"]="s", ["т"]="t", ["у"]="w", ["ф"]="f", ["х"]="x", ["ц"]="c", 
	["ч"]="č", ["ш"]="š", ["щ"]="š̍", ["ъ"]="”", ["ы"]="ə", ["ь"]="’", ["э"]="ă", ["ю"]="ju",
	["я"]="jā", ["ӏ"]="ʾ", ["А"]="Ā", ["Б"]="B", ["В"]="V", ["Г"]="Ɣ", ["Д"]="D", ["Е"]="E", 
	["Ё"]="Ë", ["Ж"]="Ž", ["З"]="Z", ["И"]="I", ["Й"]="J", ["К"]="K", ["Л"]="L", ["М"]="M", 
	["Н"]="N", ["О"]="O", ["П"]="P", ["Р"]="R", ["С"]="S", ["Т"]="T", ["У"]="W", ["Ф"]="F", 
	["Х"]="X", ["Ц"]="C", ["Ч"]="Č", ["Ш"]="Š", ["Щ"]="Š̍", ["Ъ"]="”", ["Ы"]="Ə", ["Ь"]="’",
	["Э"]="Ă", ["Ю"]="Ju", ["Я"]="Jā", ["ӏ"]="ʾ"};

local triQuadrigraphs = {
	['кхъу'] = 'q°',
	['Кхъу'] = 'Q°',
	['гъу'] = 'ġ°',
	['дзу'] = 'ʒ°',
	['жъу'] = 'ẑ°',
	['Кхъ'] = 'Q',
	['кхъ'] = 'q',
	['къу'] = 'q°',
	['кӏу'] = 'ḳ°',
	['пӏу'] = 'ṗ°',
	['тӏу'] = 'ṭ°',
	['хъу'] = 'χ°',
	['шъу'] = 'ŝ°',
	['шӏу'] = 'ṣ̂°',
	['гу'] = 'g°',
	['Гъу'] = 'Ġ°',
	['Дзу'] = 'Ʒ°',
	['Жъу'] = 'Ẑ°',
	['Къу'] = 'Q°',
	['Кӏу'] = 'Ḳ°',
	['Пӏу'] = 'Ṗ°',
	['Тӏу'] = 'Ṭ°',
	['Хъу'] = 'Χ°',
	['Шъу'] = 'Ŝ°',
	['Шӏу'] = 'Ṣ̂°',
}

local digraphs = {
	['гь'] = 'ɡ’',
	['гъ'] = 'ġ',
	['дж'] = 'ǯ̍',
	['дз'] = 'ʒ',
	['жъ'] = 'ẑ',
	['жь'] = 'ž̍',
	['ку'] = 'k°',
	['къ'] = 'q',
	['кӏ'] = 'č̣̍',
	['лъ'] = 'ł',
	['лӏ'] = 'ḷ',
	['пӏ'] = 'ṗ',
	['сӏ'] = 'ṣ̣',
	['тӏ'] = 'ṭ',
	['фӏ'] = 'f̣',
	['ху'] = 'x°',
	['хъ'] = 'χ',
	['хь'] = 'ḥ',
	['цу'] = 'c°',
	['цӏ'] = 'c̣',
	['чӏ'] = 'č̣',
	['чу'] = 'č̍°',
	['чъ'] = 'č',
	['шъ'] = 'ŝ',
	['шӏ'] = 'ṣ̂',
	['ӏу'] = 'ʾ°',
	['ӏь'] = '՚̍',
	['Гу'] = 'G°',
	['Гь'] = 'ɡ’',
	['Гъ'] = 'Ġ',
	['Дж'] = 'Ǯ̍',
	['Дз'] = 'Ʒ',
	['Жъ'] = 'Ẑ',
	['Жь'] = 'Ž̍',
	['Ку'] = 'K°',
	['Къ'] = 'Q',
	['Кӏ'] = 'Č̣̍',
	['Лъ'] = 'Ł',
	['Лӏ'] = 'Ḷ',
	['Пӏ'] = 'Ṗ',
	['Сӏ'] = 'Ṣ̣',
	['Тӏ'] = 'Ṭ',
	['Фӏ'] = 'F̣',
	['Ху'] = 'X°',
	['Хъ'] = 'Χ',
	['Хь'] = 'Ḥ',
	['Цу'] = 'C°',
	['Цӏ'] = 'C̣',
	['Чӏ'] = 'Č̣',
	['Чу'] = 'Č̍°',
	['Чъ'] = 'Č',
	['Шъ'] = 'Ŝ',
	['Шӏ'] = 'Ṣ̂',
}

function export.tr(text, lang, sc)
	local str_gsub = string.gsub
	local UTF8char = '[%z\1-\127\194-\244][\128-\191]*'
	
	-- Convert capital to lowercase palochka. Lowercase is found in tables
	-- above.
	text = str_gsub(text, mw.ustring.char(0x4C0), mw.ustring.char(0x4CF))
	
	for comb, repl in pairs(triQuadrigraphs) do
		text = str_gsub(text, comb, repl)
	end
	for comb, repl in pairs(digraphs) do
		text = str_gsub(text, comb, repl)
	end
	
	return (str_gsub(text, UTF8char, tt))
end

return export