/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ui;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JarFileChooser {
    String pattern;
    Frame frame;
    JPanel panel;

    public JarFileChooser(String pattern, JPanel panel) {
        this.pattern = pattern;
        this.panel = panel;
    }

    public String show(String filename, Point location) {
        List<String> files;
        File jarFile = new File(filename);
        if (!jarFile.exists()) {
            JOptionPane.showMessageDialog(this.panel, "Filename " + jarFile + " does not exist", null, 0);
            return null;
        }
        try {
            files = this.getFiles(jarFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.panel, "Filename " + jarFile + " had an error:\n" + e, null, 0);
            return null;
        }
        if (files.size() == 0) {
            JOptionPane.showMessageDialog(this.panel, "Filename " + jarFile + " does not contain any models", null, 0);
            return null;
        }
        return this.showListSelectionDialog(files, location);
    }

    public String showListSelectionDialog(List<String> files, Point location) {
        Frame frame = new Frame();
        final JDialog dialog = new JDialog(frame, "Jar File Chooser", true);
        dialog.setLocation(location);
        final JList<String> fileList = new JList<String>(new Vector<String>(files));
        fileList.setSelectionMode(0);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    dialog.setVisible(false);
                }
            }
        };
        fileList.addMouseListener(mouseListener);
        JScrollPane scroll = new JScrollPane(fileList);
        JButton okay = new JButton();
        okay.setText("Okay");
        okay.setToolTipText("Okay");
        okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dialog.setVisible(false);
            }
        });
        JButton cancel = new JButton();
        cancel.setText("Cancel");
        cancel.setToolTipText("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                fileList.clearSelection();
                dialog.setVisible(false);
            }
        });
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        dialog.setLayout(gridbag);
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        gridbag.setConstraints(scroll, constraints);
        dialog.add(scroll);
        constraints.gridwidth = -1;
        constraints.fill = 0;
        constraints.weighty = 0.0;
        gridbag.setConstraints(okay, constraints);
        dialog.add(okay);
        constraints.gridwidth = 0;
        gridbag.setConstraints(cancel, constraints);
        dialog.add(cancel);
        dialog.pack();
        dialog.setSize(dialog.getPreferredSize());
        dialog.setVisible(true);
        if (fileList.isSelectionEmpty()) {
            return null;
        }
        return files.get(fileList.getSelectedIndex());
    }

    public List<String> getFiles(File jarFile) throws ZipException, IOException {
        ArrayList<String> files = new ArrayList<String>();
        ZipFile zin = new ZipFile(jarFile);
        Enumeration<? extends ZipEntry> entries = zin.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.matches(this.pattern)) continue;
            files.add(name);
        }
        Collections.sort(files);
        return files;
    }
}

