/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.UnknownWordModelTrainer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Index;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractUnknownWordModelTrainer
implements UnknownWordModelTrainer {
    double treesRead;
    double totalTrees;
    Index<String> wordIndex;
    Index<String> tagIndex;
    Options op;
    Lexicon lex;

    @Override
    public void initializeTraining(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex, double totalTrees) {
        this.totalTrees = totalTrees;
        this.treesRead = 0.0;
        this.wordIndex = wordIndex;
        this.tagIndex = tagIndex;
        this.op = op;
        this.lex = lex;
    }

    @Override
    public final void train(Collection<Tree> trees) {
        this.train(trees, 1.0);
    }

    @Override
    public final void train(Collection<Tree> trees, double weight) {
        for (Tree tree : trees) {
            this.train(tree, weight);
        }
    }

    @Override
    public final void train(Tree tree, double weight) {
        this.incrementTreesRead(weight);
        int loc = 0;
        ArrayList<TaggedWord> yield = tree.taggedYield();
        for (TaggedWord tw : yield) {
            this.train(tw, loc, weight);
            ++loc;
        }
    }

    @Override
    public void incrementTreesRead(double weight) {
        this.treesRead += weight;
    }
}

