#include <algorithm>
#include "utility.h"

bool stringEndsWith(const std::string& str, const std::string& suffix) {
    return suffix.size() <= str.size() &&
           std::equal(suffix.rbegin(), suffix.rend(), str.rbegin());
}

bool stringStartsWith(const std::string& str, const std::string& prefix) {
    return prefix.size() <= str.size() &&
           std::equal(prefix.begin(), prefix.end(), str.begin());
}
