#ifndef GRAPH_H
#define GRAPH_H

#include <string>
#include <vector>
#include <iostream>
#include <unordered_map>

#define ARC_SRC(arc) ((arc) >> 16)
#define ARC_TAR(arc) (( arc )&0xffff)
#define MAKE_ARC(from, to) (((from) << 16) | (( to )&0xffff))

class EdsGraph {

public:
    using Lemma = int;
    using POSTag = int;
    using Label = int;
    using Sense = int;
    using Arc = int;

    struct Edge {
        int label_index;
        int target_index;
    };

    struct Node {
        Label label_index;
        Lemma lemma_index;
        POSTag pos_tag;
        Sense sense_index;
        std::string carg;
        std::string properties[5];

        int rule_index = -1;
        bool is_special = false;
        std::vector< Edge > out_edges;
        std::vector< int > in_edges;

        std::string toString() const;
    };

    std::vector< Node > nodes;
    std::unordered_map< Arc, int > edges;

    std::string sentence;
    std::string filename;
};

void loadGraphsFromFile(const std::string& input_file,
                        std::vector< EdsGraph >& graphs,
                        std::vector< int >& random);

std::ostream& operator<<(std::ostream& os, const EdsGraph& graph);
std::istream& operator>>(std::istream& is, EdsGraph& graph);
std::ostream& operator<<(std::ostream& os, const EdsGraph::Node& node);

#endif /* GRAPH_H */

// Local Variables:
// mode: c++
// End:
