#ifndef DATA_DRIVEN_GENERATOR_WEIGHT_H
#define DATA_DRIVEN_GENERATOR_WEIGHT_H

#include "common/transducer/macros_base.h"
#include "common/transducer/weight_base.h"
#include "include/perceptron/packed_score.h"

namespace data_driven {

enum NodeDirection {
    eSrc = 0,
    eTar,
    eSrcSrc,
    eSrcTar,
    eTarSrc,
    eTarTar
};

class DynamicWeight : public WeightBase {
protected:
    void loadScores(std::istream& is) override;
    void saveScores(std::ostream& os) const override;

public:
    // -------------------- state --------------------
    // 1 阶相邻点
    PackedScoreMap< TLemmaDirectionInt > lemma_dir_index;
    PackedScoreMap< TNodeDirectionInt > label_dir_index;
    PackedScoreMap< TNodeLemmaDirectionInt > label_lemma_dir_index;
    // 边
    PackedScoreMap< FourInt > node2_dir_index;
    PackedScoreMap< FourInt > lemma2_dir_index;
    PackedScoreMap< FiveInt > node2_edge_dir_index;
    PackedScoreMap< FiveInt > lemma2_edge_dir_index;

    PackedScoreMap< ThreeInt > node2_index;       // 当前边
    PackedScoreMap< ThreeInt > lemma2_index;      // 当前边
    PackedScoreMap< FiveInt > node2_lemma2_index; // 当前边

    PackedScoreMap< FourInt > node2_index2;       // 入边
    PackedScoreMap< FourInt > lemma2_index2;      // 入边
    PackedScoreMap< TwoInt > index2;              // 入边

    // -------------------- transition --------------------
    PackedScoreMap< FourInt > transition_edge2_index2;
    PackedScoreMap< FiveInt > transition_node3_index2;
    PackedScoreMap< FiveInt > transition_lemma3_index2;

    // -------------------- variable --------------------
    PackedScoreMap< TwoInt > var_dir_index;
    PackedScoreMap< FourInt > var_node_lemma_dir_index;
    PackedScoreMap< FourInt > var_node2_dir_index;
    PackedScoreMap< FourInt > var_lemma2_dir_index;

public:
    DynamicWeight(const std::string& input_file,
                  const std::string& output_file);

    void computeAverageFeatureWeights(const int& round) override;
};
}

#endif /* DATA_DRIVEN_GENERATOR_WEIGHT_H */
