/*
 * graphdecomposer.cpp
 *
 *  Created on: Jan 26, 2016
 *      Author: ytdu
 */

#include "common/token/word.h"
#include "common/token/pos.h"
#include "common/parser/implementations/graph_merging/graph_decomposer_gg.h"

namespace graph_merging {

graph_decomposer_gg::graph_decomposer_gg() {
	unlab = false;
}
graph_decomposer_gg::~graph_decomposer_gg() {
}

int color[MAX_SENTENCE_SIZE];
std::vector<int> cross[MAX_SENTENCE_SIZE];

void dfs(int x){
	int flag = 0;
	for (auto y : cross[x]){
		if (color[y] == 3 || color[y] == -1)
			continue;
		else if ( (color[y] ^ color[x]) == 1 )
			continue;
		else flag = 1;
	}
	if (flag == 1) {
		color[x] = 3;
		return;
	}
	for (auto y : cross[x]){
		if (color[y] == -1){
			color[y] = color[x]^1;
			dfs((int)y);
		}
	}
}

void graph_decomposer_gg::decompose(DependencyGraph & graph, DependencyGraph & ret_graphA, DependencyGraph & ret_graphB) {
//	std::cout<<"decompose..." <<std::endl;
	Sentence sent = graph.getSentence();
	int idx = 0;
	ret_graphA.clear();
	ret_graphB.clear();
	ret_graphA.m_lSentence = graph.m_lSentence;
	ret_graphA.m_lTree = graph.m_lTree;
	ret_graphB.m_lSentence = graph.m_lSentence;
	ret_graphB.m_lTree = graph.m_lTree;
	sumedge+=graph.m_lGraph.size();
	sumgraph++;
	if (graph.HaveTwoDirection())
		sumtwodir++;
	int sum3edge = 0;
	if (graph.IsProjective()){
		ret_graphA.m_lGraph = graph.m_lGraph;
		ret_graphB.m_lGraph = graph.m_lGraph;
	}
	else {
		int sumlen = graph.m_lGraph.size();
		for (int i = 0 ; i < sumlen ; i++){
			color[i] = -1;cross[i].clear();
		}
		for (auto &arc_pair : graph.m_lCrossEdge){
			int x = arc_pair.first() , y = arc_pair.second();
			//std::cout << x << ' ' << y << std::endl;
			cross[x].push_back(y);
			cross[y].push_back(x);
		}
		for (int i = 0 ; i < sumlen ; i++)
			if (color[i] != -1) continue;
			else if (cross[i].size() == 0)
				color[i] = 2;
			else{
				color[i] = 0;
				dfs(i);
			}
		for (int i = 0 ; i < sumlen ; i++){
			auto arc = graph.m_lGraph[i];
			if (color[i] == 0)
				ret_graphA.m_lGraph.push_back(arc);
			else if (color[i] == 1)
				ret_graphB.m_lGraph.push_back(arc);
			else if (color[i] == 2)
				ret_graphA.m_lGraph.push_back(arc),ret_graphB.m_lGraph.push_back(arc);
			else sum3edge++;
		}
	}
	if (unlab){
		for (auto &arc : ret_graphA.m_lGraph )
			EDGE_LABEL(arc) = "X";
		for (auto &arc : ret_graphB.m_lGraph )
			EDGE_LABEL(arc) = "X";
	}
	erroredge+=sum3edge;
	if (sum3edge == 0)
		cut0graph++;
	else if (sum3edge == 1)
		cut1graph++;
	else cut2graph++;
	//std::cout<< ret_graph.m_lGraph.size()<< std::endl;
}
} /* namespace graph_merging */
