#include <ctime>
#include <memory>
#include <fstream>
#include <iostream>
#include <cstdlib>
#include <algorithm>
#include "common/parser/depgraph.h"
#include "common/token/word.h"
#include "common/token/pos.h"
#include "graphcjj1L_run.h"
#include "graphcjj1L_depparser.h"

namespace graphcjj1L {
	Run::Run() = default;

	Run::~Run() = default;

	void Run::train(const std::string & sInputFile, const std::string & sFeatureInput, const std::string & sFeatureOutput) const {
		int nRound = 0;
		int inRound = 0;
		int twodirRound = 0;
		int oneringRound = 0;
		int tailRound = 0;
		DependencyGraph ref_sent;
		int onecutRound = 0;
		int twocutRound = 0;
		int threecutRound = 0;
		int overthreecutRound = 0;
		int sumedge = 0;
		int sumedge2 = 0;

		std::vector<DependencyGraph> treevector;
		std::vector<int> ran;
		std::cout << "Graphcjj1 Training iteration is started..." << std::endl;

		std::unique_ptr<DepParser> parser(new DepParser(sFeatureInput, sFeatureOutput, ParserState::TRAIN));
		std::ifstream input(sInputFile);
		int idx = 0;
		treevector.clear();
		ran.clear();
		if (input)
		{
			while (input >> ref_sent)
			{
				//ytdu
				for (auto node : ref_sent.getSentence()) {
					TWord::code(SENT_WORD(node));
					TPOSTag::code(SENT_POSTAG(node));
				}

				inRound++;
				if (ref_sent.IsProjective() || ref_sent.OneEdgeCut_Plannar(1) || ref_sent.TwoEdgeCut_Plannar(1) || ref_sent.ThreeEdgeCut_Plannar(1))
				{
					treevector.push_back(ref_sent);
					ran.push_back(idx++);
				}

			}
		}
//		srand(time(0));
		random_shuffle(ran.begin(), ran.end());
		
		if (idx) {
			while (idx) {
				idx--;
				++nRound;
				parser->train(treevector[ran[idx]], nRound);
			}
			parser->outans();
			parser->finishtraining();
		}
		input.close();
		std::cout << inRound << std::endl;
		std::cout << "Total edge" << ' ' << sumedge << std::endl;
		std::cout << "Project% " << nRound << " / " << inRound << ' ' << 1.0 * nRound / inRound << std::endl;
		//std::cout << "Edge% " <<sumedge2<<' '<<sumedge<<' '<< 1.0*sumedge2 / sumedge << std::endl;
		//system("pause");
		std::cout << "Done." << std::endl;
	}

	void Run::parse(const std::string & sInputFile, const std::string & sOutputFile, const std::string & sFeatureFile) const {

		Sentence sentence;
		DependencyGraph tree;

		std::cout << "Parsing started" << std::endl;

		std::unique_ptr<DepParser> parser(new DepParser(sFeatureFile, sFeatureFile, ParserState::PARSE));
		std::ifstream input(sInputFile);
		std::ofstream output(sOutputFile);
		int round = 0;
		if (input) {
			while (input >> sentence) {
				if (sentence.size() < MAX_SENTENCE_SIZE) {
					parser->parse(sentence, &tree);
					output << tree;
					tree.clear();
					if (++round % 100 == 0) std::cout << round << std::endl;
				}
			}
		}
		input.close();
		output.close();
	}

	void Run::goldtest(const std::string & sInputFile, const std::string & sFeatureInput) const {
		int nRound = 0;
		DependencyGraph ref_sent;

		std::cout << "GoldTest iteration is started..." << std::endl;

		auto time_begin = time(NULL);

		std::unique_ptr<DepParser> parser(new DepParser(sFeatureInput, "", ParserState::GOLDTEST));

		std::ifstream input(sInputFile);
		if (input) {
			while (input >> ref_sent) {
				++nRound;
				parser->train(ref_sent, nRound);
			}
			parser->outans();
		}
		input.close();

		std::cout << "total " << nRound << " round" << std::endl;

		auto time_end = time(NULL);

		std::cout << "Done." << std::endl;

		std::cout << "Training has finished successfully. Total time taken is: " << difftime(time_end, time_begin) << "s" << std::endl;
	}
}
