/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.morefeatures;

import edu.pku.coli.mrs.mrs.implementations.Constrain;
import edu.pku.coli.mrs.mrs.implementations.MRS;
import edu.pku.coli.mrs.mrs.implementations.MRSReader;
import edu.pku.coli.mrs.mrs.implementations.Relation;
import edu.pku.coli.mrs.mrs.utils.Label;
import edu.pku.coli.mrs.mrs.utils.Span;
import edu.pku.coli.mrs.mrs.utils.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import matetools.is2.data.D6;
import matetools.is2.data.DX;
import matetools.is2.data.Instances;
import matetools.is2.data.Long2IntInterface;
import matetools.is2.data.SentenceData09;
import matetools.is2.modification.morefeatures.MoreFeaturesInterface;
import matetools.is2.parser.D5;
import matetools.is2.parser.Extractor;

public class MRSFeatures
extends MoreFeaturesInterface {
    static String REL_NAME = "MRS_REL_NAME";
    static String REL_LAB_NAME = "MRS_REL_LAB";
    static String REL_LAB_VAR = "MRS_REL_LAB_VAR";
    static String CONSTRAIN_ARG = "MRS_CONSTRAIN_ARG";
    DX d0;
    String trainMRSdir;
    String testMRSdir;
    MRSReader reader;

    public MRSFeatures(String trainMRSdir, String testMRSdir) {
        this.trainMRSdir = trainMRSdir;
        this.testMRSdir = testMRSdir;
    }

    @Override
    public void register() {
        this.reader.startReading();
        MRS mrs = this.reader.readNext();
        while (mrs != null) {
            for (Relation rel : mrs.rels) {
                if (rel.name.startsWith("_")) {
                    rel.name = rel.name.substring(rel.name.indexOf(95, 1));
                }
                this.mf.register(REL_NAME, rel.name);
                for (Label lab : rel.labels) {
                    this.mf.register(REL_LAB_NAME, lab.name);
                    if (lab.var.startsWith("\"")) continue;
                    this.mf.register(REL_LAB_VAR, lab.var);
                }
            }
            for (Constrain cons : mrs.hcons) {
                this.mf.register(CONSTRAIN_ARG, cons.lArg);
                this.mf.register(CONSTRAIN_ARG, cons.hArg);
            }
            mrs = this.reader.readNext();
        }
    }

    @Override
    public void init(int what) {
        Long2IntInterface l2i = MoreFeaturesInterface.l2i;
        this.d0 = what == 1 ? new D6(l2i) : new D5(l2i);
        this.d0.a0 = Extractor.s_type;
        this.d0.a1 = Extractor.s_rel;
        this.d0.a2 = this.mf.getFeatureCounter().get(REL_LAB_NAME).intValue();
        this.d0.a3 = this.mf.getFeatureCounter().get(REL_NAME).intValue();
        this.d0.a4 = this.mf.getFeatureCounter().get(REL_LAB_NAME).intValue();
        this.d0.a5 = this.mf.getFeatureCounter().get(REL_NAME).intValue();
        this.d0.fix();
    }

    @Override
    public void initFeats() {
        int i = 0;
        while (i < 10) {
            this.mf.register("TYPE", "MRS" + i);
            ++i;
        }
        this.featureIndex = this.mf.getFeatureCounter().get("TYPE") - 2;
    }

    @Override
    public void startReadingTrain() {
        this.reader = new MRSReader(this.trainMRSdir);
    }

    @Override
    public void startReadingTest() {
        this.reader = new MRSReader(this.testMRSdir);
    }

    @Override
    public void createFeatures(Instances is, SentenceData09 instance) {
        int ins = is.size() - 1;
        MRS mrs = this.reader.readNext();
        this.alignTokens(mrs, instance.forms);
        if (mrs.sent.size != is.forms[ins].length) {
            throw new RuntimeException("Inconsistent MRS length of the " + ins + "th sentence");
        }
        ArrayList<IntRelation> intRels = new ArrayList<IntRelation>(mrs.rels.size());
        for (Relation rel : mrs.rels) {
            if (rel.name.startsWith("_")) {
                rel.name = rel.name.substring(rel.name.indexOf(95, 1));
            }
            int name = this.mf.getValue(REL_NAME, rel.name);
            ArrayList<IntLabel> labs = new ArrayList<IntLabel>(rel.labels.size());
            for (Label lab : rel.labels) {
                int lname = this.mf.getValue(REL_LAB_NAME, lab.name);
                int var = lab.var.startsWith("\"") ? -1 : this.mf.getValue(REL_LAB_VAR, lab.var);
                labs.add(new IntLabel(lname, var));
            }
            intRels.add(new IntRelation(name, labs));
        }
        List[] tokenRels = new List[mrs.sent.size];
        int j = 0;
        while (j < tokenRels.length) {
            tokenRels[j] = new ArrayList();
            ++j;
        }
        Token[] tokens = mrs.sent.tokens;
        List rels = mrs.rels;
        int i = 0;
        while (i < rels.size()) {
            int j2 = 1;
            while (j2 < mrs.sent.size) {
                if (((Relation)rels.get((int)i)).span.contains((Span)tokens[j2].second())) {
                    tokenRels[j2].add((IntRelation)intRels.get(i));
                }
                ++j2;
            }
            ++i;
        }
        IntMRS intMRS = new IntMRS(intRels, tokenRels);
        is.moreIntFeats[ins] = new MoreFeaturesInterface.MoreIntFeats(intMRS);
    }

    private void alignTokens(MRS mrs, String[] forms) {
        String sent = mrs.sent.sent;
        Token[] tokens = new Token[forms.length];
        int fromIndex = 0;
        int i = 1;
        while (i < forms.length) {
            tokens[i] = new Token();
            if ((fromIndex = sent.indexOf(forms[i], fromIndex)) == -1) {
                throw new RuntimeException("Inconsistent MRS and sentence: " + Arrays.toString(forms));
            }
            tokens[i].refer(forms[i], fromIndex, fromIndex + forms[i].length() - 1);
            fromIndex += forms[i].length();
            ++i;
        }
        mrs.sent.size = forms.length;
    }

    @Override
    public void addFirstOrderFeatures(Instances is, int inst, int w1, int w2, int label, List<Long> ret) {
        this.addFirstOrderFeaturesHelper(is, inst, w1, w2, label, ret, this.featureIndex);
    }

    public void addFirstOrderFeaturesHelper(Instances is, int inst, int w1, int w2, int label, List<Long> ret, int n) {
        IntMRS mrs = is.moreIntFeats[inst].mrs;
        for (IntRelation reli : mrs.tokenRels[w1]) {
            for (IntRelation relj : mrs.tokenRels[w2]) {
                for (IntLabel li : reli.labs) {
                    for (IntLabel lj : relj.labs) {
                        if (li.var == -1 || li.var != lj.var) continue;
                        this.d0.v0 = n;
                        this.d0.v1 = label;
                        this.d0.v2 = li.name;
                        this.d0.v3 = reli.name;
                        this.d0.v4 = lj.name;
                        this.d0.v5 = relj.name;
                        this.d0.cz6();
                        ret.add(this.d0.getVal());
                    }
                }
            }
        }
    }

    static class IntConstrain {
        int larg;
        int harg;

        IntConstrain(int larg, int harg) {
            this.larg = larg;
            this.harg = harg;
        }
    }

    static class IntLabel {
        int name;
        int var;

        IntLabel(int name, int var) {
            this.name = name;
            this.var = var;
        }
    }

    static class IntMRS {
        List<IntRelation> rels;
        List<IntRelation>[] tokenRels;

        IntMRS(List<IntRelation> rels, List<IntRelation>[] tokenRels) {
            this.rels = rels;
            this.tokenRels = tokenRels;
        }
    }

    static class IntRelation {
        int name;
        List<IntLabel> labs;

        IntRelation(int name, List<IntLabel> labs) {
            this.name = name;
            this.labs = labs;
        }
    }
}

