/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.servlet.BasketFactory;
import fig.servlet.BasketItem;
import fig.servlet.FieldListMap;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import java.util.Collections;

public class BasketView
extends Item {
    public static final BasketFactory defaultBasketFactory = new BasketFactory(){

        @Override
        public BasketItem newBasketItem(Item parent, String name, String sourcePath) {
            return new BasketItem(parent, name, sourcePath);
        }
    };
    private BasketFactory factory;
    public final BasketItem clipboardBasket;

    @Override
    protected String getDescription() {
        return "A scratch area" + (this.clipboardBasket != null ? " (includes clipboard)" : "") + ".";
    }

    public BasketView(Item parent, String name, String sourcePath, BasketFactory factory, boolean includeClipboard) {
        super(parent, name, sourcePath);
        this.factory = factory;
        IOUtils.createNewDirIfNotExistsEasy(sourcePath);
        IOUtils.createNewFileIfNotExistsEasy(this.fileSourcePath());
        if (includeClipboard) {
            this.clipboardBasket = (BasketItem)this.newItem("clipboard");
            this.addItem(this.clipboardBasket);
        } else {
            this.clipboardBasket = null;
        }
    }

    public BasketView(Item parent, String name, String sourcePath, boolean includeClipboard) {
        this(parent, name, sourcePath, defaultBasketFactory, includeClipboard);
    }

    @Override
    public FieldListMap getItemsFields() {
        return this.factory.newBasketItem(null, null, null).getMetadataFields();
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.updateItemsFromFile(spec, this.clipboardBasket != null ? Collections.singletonList(this.clipboardBasket) : Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        this.updateChildren(spec, priority.next());
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    protected Item newItem(String name) {
        return this.factory.newBasketItem(this, name, this.childNameToIndexSourcePath(name));
    }

    @Override
    protected String itemToHandle(Item item) throws MyException {
        if (item == this.clipboardBasket) {
            return null;
        }
        return super.itemToHandle(item);
    }
}

