/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.Exceptions;
import fig.basic.Fmt;
import fig.basic.IOUtils;
import fig.basic.IntRef;
import fig.basic.ListUtils;
import fig.basic.MapUtils;
import fig.basic.NumUtils;
import fig.basic.Pair;
import fig.basic.StatFig;
import fig.basic.StrUtils;
import fig.record.ArgsParser;
import fig.record.CommandNode;
import fig.record.CommandUtils;
import fig.record.FullRecordNode;
import fig.record.GnuPlotter;
import fig.record.LeafRecordNode;
import fig.record.LocalCommandEnv;
import fig.record.Mandate;
import fig.record.PathRecordNode;
import fig.record.PeriodicSubsetHint;
import fig.record.RecordNode;
import fig.record.RecordNodeUtils;
import fig.record.SubsetHintUtils;
import fig.record.TwigRecordNode;
import fig.record.VarBindingList;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class FuncCommandNode
extends TwigRecordNode
implements CommandNode {
    public static final CommandNode noOpCmd = new FuncCommandNode("noOp", Collections.EMPTY_LIST, null, false);
    public static final CommandNode identityCmd = new FuncCommandNode("identity", Collections.EMPTY_LIST, null, false);
    public static final CommandNode childKeysCmd = new FuncCommandNode("keySkeleton", Collections.singletonList("1"), identityCmd, false);
    public static final CommandNode keySkeletonCmd = new FuncCommandNode("keySkeleton", Collections.EMPTY_LIST, identityCmd, false);
    public static final CommandNode withoutChildrenCmd = new FuncCommandNode("withoutChildren", Collections.EMPTY_LIST, identityCmd, false);
    private final String name;
    private final List<String> args;
    private final boolean applyToChildren;
    private ArgsParser parser;

    public static boolean isImmutableCmd(CommandNode cmd) {
        return cmd == noOpCmd || cmd == identityCmd || cmd == childKeysCmd || cmd == keySkeletonCmd || cmd == withoutChildrenCmd;
    }

    public FuncCommandNode(String name, List<String> args, CommandNode child, boolean applyToChildren) {
        super(String.valueOf(applyToChildren ? "map-" : "") + name, StrUtils.join(args), child);
        this.name = name;
        this.args = args;
        this.applyToChildren = applyToChildren;
        this.parser = new ArgsParser('?', args);
    }

    public String getName() {
        return this.name;
    }

    private FuncCommandNode notApplyToChildrenCmd() {
        return new FuncCommandNode(this.name, this.args, identityCmd, false);
    }

    private RecordNode extractKeySkeleton(RecordNode record, int maxDepth, String key, String value, IntRef numNodes) {
        FullRecordNode result = new FullRecordNode(key, value);
        ++numNodes.value;
        if (maxDepth > 0) {
            String childKey;
            LinkedHashMap counts = new LinkedHashMap();
            for (RecordNode childRecord : record.getChildren()) {
                childKey = childRecord.getKey();
                MapUtils.incr(counts, childKey, true);
            }
            for (RecordNode childRecord : record.getChildren()) {
                childKey = childRecord.getKey();
                if (!counts.containsKey(childKey)) continue;
                result.addChild(this.extractKeySkeleton(childRecord, maxDepth - 1, childKey, "" + counts.get(childKey), numNodes));
                counts.remove(childKey);
            }
        }
        return result;
    }

    private static RecordNode transposeRecordNode(RecordNode record) {
        FullRecordNode newRecord = new FullRecordNode(record.getKey(), record.getValue());
        List<RecordNode> children = record.getChildren();
        RecordNode prototypeRecord = children.get(0);
        int i = 0;
        while (i < prototypeRecord.numChildren()) {
            FullRecordNode newChild = new FullRecordNode(prototypeRecord.getChildren().get(i).getKey(), prototypeRecord.getChildren().get(i).getValue());
            for (RecordNode child : children) {
                if (i >= child.numChildren()) continue;
                newChild.addChild(child.getChildren().get(i).shallowCopy(child.getKey(), child.getValue()));
            }
            newRecord.addChild(newChild);
            ++i;
        }
        return newRecord;
    }

    private static RecordNode replaceIndex(RecordNode tree, List<RecordNode> list) {
        if (tree.numChildren() == 0) {
            int idx = (int)tree.getDoubleValue();
            if (idx < 0 || idx >= list.size()) {
                return LeafRecordNode.nullNode;
            }
            return list.get(idx);
        }
        FullRecordNode newTree = new FullRecordNode(tree.getKey(), tree.getValue());
        for (RecordNode child : tree.getChildren()) {
            newTree.addChild(FuncCommandNode.replaceIndex(child, list));
        }
        return newTree;
    }

    private static RecordNode raise(RecordNode record, String key, String value) {
        return new TwigRecordNode(key, value, record);
    }

    private static RecordNode raise(RecordNode record) {
        return new TwigRecordNode(null, null, record);
    }

    @Override
    public RecordNode exec(LocalCommandEnv localEnv) {
        return new ExecState(localEnv).exec();
    }

    @Override
    public RecordNode withoutChildren() {
        return new FuncCommandNode(this.name, this.args, null, this.applyToChildren);
    }

    private class ExecState {
        private LocalCommandEnv localEnv;

        public ExecState(LocalCommandEnv localEnv) {
            this.localEnv = localEnv;
        }

        public RecordNode exec() {
            RecordNode newResult;
            RecordNode record = this.localEnv.getCurrRecord();
            VarBindingList bindings = this.localEnv.getVarBindingList();
            CommandNode childCmd = (CommandNode)FuncCommandNode.this.getChild();
            if (FuncCommandNode.this.name.equals("identity")) {
                return record;
            }
            if (FuncCommandNode.this.name.equals("noOp")) {
                return LeafRecordNode.nullNode;
            }
            if (FuncCommandNode.this.name.equals("sub") || FuncCommandNode.this.name.equals("head") || FuncCommandNode.this.name.equals("tail") || FuncCommandNode.this.name.equals("Sub") || FuncCommandNode.this.name.equals("Head") || FuncCommandNode.this.name.equals("Tail")) {
                PeriodicSubsetHint hint;
                String lname = FuncCommandNode.this.name.toLowerCase();
                if (lname.equals("sub")) {
                    hint = new PeriodicSubsetHint(FuncCommandNode.this.args, bindings);
                } else if (lname.equals("head")) {
                    FuncCommandNode.this.parser.setNames("count").parse(bindings);
                    hint = new PeriodicSubsetHint(ListUtils.newList("0", "" + FuncCommandNode.this.parser.getInt("count", 10)), bindings);
                } else if (lname.equals("tail")) {
                    FuncCommandNode.this.parser.setNames("count").parse(bindings);
                    hint = new PeriodicSubsetHint(ListUtils.newList("" + -FuncCommandNode.this.parser.getInt("count", 10), "1f"), bindings);
                } else {
                    throw Exceptions.unknownCase;
                }
                LocalCommandEnv childLocalEnv = this.localEnv.withHint(hint);
                if (!lname.equals(FuncCommandNode.this.name)) {
                    childLocalEnv = childLocalEnv.withDefaultHint(hint);
                }
                return this.localEnv.applyHint(childCmd.exec(childLocalEnv));
            }
            if (FuncCommandNode.this.name.equals("map")) {
                FullRecordNode result = new FullRecordNode("map", null);
                FuncCommandNode.this.parser.parse(bindings);
                String var = FuncCommandNode.this.parser.getHard(0);
                int i = 1;
                while (i < FuncCommandNode.this.parser.size()) {
                    String val = FuncCommandNode.this.parser.getHard(i);
                    RecordNode node = childCmd.exec(this.localEnv.withHintIsDefault().withNewBinding(var, val).withIndex(i - 1));
                    result.addChild(node.shallowCopy(var, val));
                    ++i;
                }
                return result;
            }
            RecordNode result = childCmd.exec(this.localEnv.withHintIsDefault());
            if (FuncCommandNode.this.applyToChildren) {
                return SubsetHintUtils.applyHint(this.localEnv.getHint(), result, FuncCommandNode.this.notApplyToChildrenCmd(), this.localEnv.withHintIsDefault());
            }
            if (FuncCommandNode.this.name.equals("define")) {
                String var = (String)FuncCommandNode.this.args.get(0);
                String val = (String)FuncCommandNode.this.args.get(1);
                this.localEnv.getGlobalEnv().putVar(var, val);
                newResult = FuncCommandNode.raise(new LeafRecordNode(var, val));
            } else if (FuncCommandNode.this.name.equals("key")) {
                FuncCommandNode.this.parser.setNames("newKey").parse(bindings);
                String newKey = FuncCommandNode.this.parser.get("newKey", null);
                newResult = result.shallowCopy(newKey, result.getValue());
            } else if (FuncCommandNode.this.name.equals("replaceKey")) {
                String newKey = result.getKey();
                FuncCommandNode.this.parser.parse(bindings);
                int i = 0;
                while (i < FuncCommandNode.this.parser.size()) {
                    List<String> kv = StrUtils.splitIgnoreEscaped(FuncCommandNode.this.parser.getHard(i), "=");
                    if (kv.size() == 0) {
                        throw new RuntimeException("Invalid argument: " + FuncCommandNode.this.parser.getHard(i));
                    }
                    if (kv.size() == 1) {
                        kv.add("");
                    }
                    newKey = newKey.replaceAll(kv.get(0), kv.get(1));
                    ++i;
                }
                newResult = result.shallowCopy(newKey, result.getValue());
            } else if (FuncCommandNode.this.name.equals("childKeys")) {
                newResult = new FullRecordNode(result.getKey(), result.getValue());
                FuncCommandNode.this.parser.parse(bindings);
                int i = 0;
                while (i < result.numChildren()) {
                    RecordNode childNode = result.getChildren().get(i);
                    String childKey = FuncCommandNode.this.parser.get(i, childNode.getKey());
                    String childValue = childNode.getValue();
                    newResult.addChild(childNode.shallowCopy(childKey, childValue));
                    ++i;
                }
            } else if (FuncCommandNode.this.name.equals("childValues")) {
                newResult = new FullRecordNode(result.getKey(), result.getValue());
                FuncCommandNode.this.parser.parse(bindings);
                int i = 0;
                while (i < result.numChildren()) {
                    RecordNode childNode = result.getChildren().get(i);
                    String childKey = childNode.getKey();
                    String childValue = FuncCommandNode.this.parser.get(i, childNode.getValue());
                    newResult.addChild(childNode.shallowCopy(childKey, childValue));
                    ++i;
                }
            } else if (FuncCommandNode.this.name.equals("save")) {
                FuncCommandNode.this.parser.setNames("out", "append").parse(bindings);
                RecordNodeUtils.writeRecordNode(result, FuncCommandNode.this.parser.getHard("out"), FuncCommandNode.this.parser.getBoolean("append", false));
                newResult = result.withoutChildren();
            } else if (FuncCommandNode.this.name.equals("raise")) {
                FuncCommandNode.this.parser.setNames("key", "value").parse(bindings);
                String key = FuncCommandNode.this.parser.get("key", null);
                String value = FuncCommandNode.this.parser.get("value", null);
                newResult = FuncCommandNode.raise(result, key, value);
            } else if (FuncCommandNode.this.name.equals("diff")) {
                double diff = result.numChildren() < 2 ? Double.NaN : result.getChildren().get(0).getDoubleValue() - result.getChildren().get(1).getDoubleValue();
                newResult = RecordNodeUtils.prependKeyValue(result, "diff", "" + diff);
            } else if (FuncCommandNode.this.name.equals("transpose")) {
                newResult = FuncCommandNode.transposeRecordNode(result);
            } else if (FuncCommandNode.this.name.equals("keySkeleton")) {
                FuncCommandNode.this.parser.setNames("maxDepth").parse(bindings);
                int maxDepth = FuncCommandNode.this.parser.getInt("maxDepth", Integer.MAX_VALUE);
                newResult = FuncCommandNode.this.extractKeySkeleton(result, maxDepth, result.getKey(), result.getValue(), new IntRef(0));
            } else if (FuncCommandNode.this.name.equals("withoutChildren")) {
                newResult = result.withoutChildren();
            } else if (FuncCommandNode.this.name.equals("unloadChildren")) {
                if (result instanceof PathRecordNode) {
                    ((PathRecordNode)result).unloadChildren();
                    System.gc();
                }
                newResult = result.withoutChildren();
            } else if (FuncCommandNode.this.name.equals("filestat")) {
                FuncCommandNode.this.parser.setNames("type").parse(bindings);
                String type = FuncCommandNode.this.parser.getHard("type");
                String key = null;
                String value = null;
                if (type != null && result instanceof PathRecordNode) {
                    File path = ((PathRecordNode)result).getPath();
                    key = type;
                    if (type.equals("mtime")) {
                        value = "" + path.lastModified();
                    } else if (type.equals("path")) {
                        value = path.toString();
                    } else if (type.equals("size")) {
                        value = "" + path.length();
                    }
                }
                newResult = new TwigRecordNode(key, value, result);
            } else if (FuncCommandNode.this.name.equals("open")) {
                if (result instanceof PathRecordNode) {
                    File realPath = ((PathRecordNode)result).getPath();
                    Mandate mandate = new Mandate(false);
                    String tempPath = mandate.tempifyFileName(realPath.getName());
                    mandate.addCommand("open " + tempPath);
                    mandate.addFile(new Mandate.FileBundle(tempPath, realPath));
                    try {
                        this.localEnv.getReceiver().executeMandate(mandate);
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
                newResult = new LeafRecordNode(result.getKey(), result.getValue());
            } else if (FuncCommandNode.this.name.equals("elect")) {
                if (result.numChildren() < 2) {
                    newResult = result;
                } else {
                    List<RecordNode> nodes = result.getChildren();
                    RecordNode root = nodes.get(0).withoutChildren();
                    FullRecordNode newRoot = new FullRecordNode(root.getKey(), root.getValue());
                    for (RecordNode child : root.getChildren()) {
                        newRoot.addChild(child);
                    }
                    int i = 1;
                    while (i < nodes.size()) {
                        newRoot.addChild(nodes.get(i));
                        ++i;
                    }
                    newResult = new TwigRecordNode(result.getKey(), result.getValue(), newRoot);
                }
            } else if (FuncCommandNode.this.name.equals("stretch")) {
                newResult = new TwigRecordNode(result.getKey(), null, new LeafRecordNode("value", result.getValue()));
            } else {
                FullRecordNode newFullResult = new FullRecordNode(result.getKey(), result.getValue());
                newResult = newFullResult;
                if (FuncCommandNode.this.name.equals("source")) {
                    FuncCommandNode.this.parser.setNames("path", "detail").parse(bindings);
                    boolean detail = FuncCommandNode.this.parser.getBoolean("detail", false);
                    String path = FuncCommandNode.this.parser.get("path", result.getKey());
                    int lineNum = 0;
                    RecordNode rootRecord = this.localEnv.getGlobalEnv().getRootRecord();
                    this.localEnv = this.localEnv.withCurrRecord(rootRecord).withHintIsDefault();
                    for (String line : IOUtils.readProgramLinesHard(path)) {
                        ++lineNum;
                        CommandNode cmd = CommandUtils.parse(line, this.localEnv.getCmdEnv());
                        RecordNode child = cmd.exec(this.localEnv);
                        if (!detail) continue;
                        newFullResult.addChild(child.shallowCopy("line", "" + lineNum));
                    }
                } else if (FuncCommandNode.this.name.equals("remove0")) {
                    for (RecordNode node : result.getChildren()) {
                        if (node.numChildren() <= 0) continue;
                        newFullResult.addChild(node);
                    }
                } else if (FuncCommandNode.this.name.equals("replaceIndex")) {
                    RecordNode list = result.getChildren().get(0);
                    RecordNode tree = result.getChildren().get(1);
                    newResult = FuncCommandNode.replaceIndex(tree, list.getChildren());
                } else if (FuncCommandNode.this.name.equals("flatten")) {
                    FuncCommandNode.this.parser.setNames("propagate").parse(bindings);
                    String propagate = FuncCommandNode.this.parser.get("propagate", null);
                    if (propagate == null && result.numChildren() == 1) {
                        newResult = result.getChildren().get(0).shallowCopy(result.getKey(), result.getValue());
                    }
                    for (RecordNode node : result.getChildren()) {
                        for (RecordNode child : node.getChildren()) {
                            RecordNode newChild = "prepend".equals(propagate) ? RecordNodeUtils.prependKeyValue(child, node.getKey(), node.getValue()) : ("append".equals(propagate) ? RecordNodeUtils.appendKeyValue(child, node.getKey(), node.getValue()) : ("integrate".equals(propagate) ? child.shallowCopy(String.valueOf(node.getKey()) + " " + child.getKey(), String.valueOf(node.getValue()) + " " + child.getValue()) : ("replace".equals(propagate) ? child.shallowCopy(node.getKey(), node.getValue()) : child)));
                            newFullResult.addChild(newChild);
                        }
                    }
                } else if (FuncCommandNode.this.name.equals("stat")) {
                    StatFig fig = new StatFig();
                    for (RecordNode node : result.getChildren()) {
                        fig.add(node.getDoubleValue());
                    }
                    newFullResult.addChild(new LeafRecordNode("count", "" + fig.count()));
                    newFullResult.addChild(new LeafRecordNode("min", "" + fig.min()));
                    newFullResult.addChild(new LeafRecordNode("max", "" + fig.max()));
                    newFullResult.addChild(new LeafRecordNode("mean", "" + fig.mean()));
                    newFullResult.addChild(new LeafRecordNode("stddev", "" + fig.stddev()));
                    newFullResult.addChild(new LeafRecordNode("sum", "" + fig.sum()));
                } else if (FuncCommandNode.this.name.equals("min") || FuncCommandNode.this.name.equals("max")) {
                    boolean isMin = FuncCommandNode.this.name.equals("min");
                    RecordNode bestNode = null;
                    int bestIndex = -1;
                    double bestValue = isMin ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                    int index = 0;
                    while (index < result.numChildren()) {
                        RecordNode node = result.getChildren().get(index);
                        double value = node.getDoubleValue();
                        if (isMin ? value < bestValue : value > bestValue) {
                            bestValue = value;
                            bestNode = node;
                            bestIndex = index;
                        }
                        ++index;
                    }
                    if (bestNode != null) {
                        newFullResult.addChild(RecordNodeUtils.appendKeyValue(bestNode, "index", "" + bestIndex));
                    }
                } else if (FuncCommandNode.this.name.equals("combineSeries")) {
                    FuncCommandNode.this.parser.setNames("mode").parse(bindings);
                    String mode = FuncCommandNode.this.parser.get("mode", "none");
                    ArrayList<Double> evalxs = new ArrayList<Double>();
                    String key = null;
                    ArrayList runs = new ArrayList();
                    for (RecordNode runNode : result.getChildren()) {
                        ArrayList<Pair<Double, Double>> run = new ArrayList<Pair<Double, Double>>();
                        int index = 0;
                        for (RecordNode node : runNode.getChildren()) {
                            double[] p;
                            if (key == null) {
                                key = node.getKey();
                            }
                            if ((p = StrUtils.doubleSplit(RecordNodeUtils.getPrimaryValue(node))).length == 1) {
                                p = new double[]{index, p[0]};
                            }
                            if (p.length != 2) {
                                throw Exceptions.bad("Expected length 2 vector, got '%s' instead", Fmt.D(p));
                            }
                            evalxs.add(p[0]);
                            run.add(new Pair<Double, Double>(p[0], p[1]));
                            ++index;
                        }
                        Collections.sort(run, new Pair.FirstComparator());
                        runs.add(run);
                    }
                    Collections.sort(evalxs);
                    ArrayList<Double> tmpxs = new ArrayList<Double>();
                    double lastx = Double.NaN;
                    Iterator<Object> iterator = evalxs.iterator();
                    while (iterator.hasNext()) {
                        double x = (Double)iterator.next();
                        if (NumUtils.equals(x, lastx)) continue;
                        tmpxs.add(x);
                        lastx = x;
                    }
                    evalxs = tmpxs;
                    newResult = new FullRecordNode(result.getKey(), result.getValue());
                    int R = runs.size();
                    int[] ri = new int[R];
                    Iterator iterator2 = evalxs.iterator();
                    while (iterator2.hasNext()) {
                        double evalx = (Double)iterator2.next();
                        StatFig fig = new StatFig();
                        int r = 0;
                        while (r < R) {
                            List run = (List)runs.get(r);
                            double x = Double.NaN;
                            double y = Double.NaN;
                            while (ri[r] < run.size()) {
                                x = (Double)((Pair)run.get(ri[r])).getFirst();
                                y = (Double)((Pair)run.get(ri[r])).getSecond();
                                if (x >= evalx) break;
                                int n = r;
                                ri[n] = ri[n] + 1;
                            }
                            if (ri[r] == run.size()) break;
                            if (NumUtils.equals(x, evalx)) {
                                fig.add(y);
                            } else if (ri[r] - 1 >= 0) {
                                double prevx = (Double)((Pair)run.get(ri[r] - 1)).getFirst();
                                double prevy = (Double)((Pair)run.get(ri[r] - 1)).getSecond();
                                assert (prevx < evalx && evalx <= x) : String.valueOf(prevx) + " " + evalx + " " + x;
                                fig.add(prevy + (evalx - prevx) / (x - prevx) * (y - prevy));
                            }
                            ++r;
                        }
                        if (fig.count() != (double)R) continue;
                        if (mode.equals("none")) {
                            newResult.addChild(new LeafRecordNode(key, String.valueOf(evalx) + " " + fig.mean()));
                            continue;
                        }
                        if (mode.equals("stddev")) {
                            newResult.addChild(new LeafRecordNode(key, String.valueOf(evalx) + " " + fig.mean() + " " + fig.stddev()));
                            continue;
                        }
                        if (mode.equals("range")) {
                            newResult.addChild(new LeafRecordNode(key, String.valueOf(evalx) + " " + fig.mean() + " " + fig.min() + " " + fig.max()));
                            continue;
                        }
                        throw Exceptions.unknownCase(mode);
                    }
                } else if (FuncCommandNode.this.name.equals("flushplot")) {
                    this.localEnv.getCmdEnv().flushPlot();
                    newResult = result;
                } else if (FuncCommandNode.this.name.equals("plottime") || FuncCommandNode.this.name.equals("plothist") || FuncCommandNode.this.name.equals("plotscatter")) {
                    GnuPlotter.Plot plot;
                    String[] names = new String[]{"xcol", "ycol", "zcol", "wcol"};
                    names = ListUtils.append(names, GnuPlotter.Plot.propertyNames);
                    FuncCommandNode.this.parser.setNames(names).parse(bindings);
                    String plotKey = result.getDescription(RecordNode.DescriptionType.human).replaceAll("\t", " ");
                    GnuPlotter plotter = this.localEnv.getPlotter();
                    if (FuncCommandNode.this.name.equals("plotscatter")) {
                        plot = plotter.getScatter();
                    } else if (FuncCommandNode.this.name.equals("plottime")) {
                        plot = plotter.getTimeSeries();
                    } else if (FuncCommandNode.this.name.equals("plothist")) {
                        plot = plotter.getHistogram();
                    } else {
                        throw Exceptions.unknownCase;
                    }
                    plot.setProperties(FuncCommandNode.this.parser);
                    int xcol = FuncCommandNode.this.parser.getInt("xcol", 0);
                    int ycol = FuncCommandNode.this.parser.getInt("ycol", 1);
                    int zcol = FuncCommandNode.this.parser.getInt("zcol", 2);
                    int wcol = FuncCommandNode.this.parser.getInt("wcol", 3);
                    int numGoodPoints = 0;
                    for (RecordNode node : result.getChildren()) {
                        double[] p = StrUtils.doubleSplit(RecordNodeUtils.getPrimaryValue(node));
                        assert (p.length > 0);
                        double x = ListUtils.get(p, xcol, Double.NaN);
                        double y = ListUtils.get(p, ycol, Double.NaN);
                        double z = ListUtils.get(p, zcol, Double.NaN);
                        double w = ListUtils.get(p, wcol, Double.NaN);
                        if (FuncCommandNode.this.name.equals("plotscatter")) {
                            if (xcol < p.length && ycol < p.length && zcol < p.length) {
                                if (!plot.addPoint(plotKey, x, y, z)) continue;
                                ++numGoodPoints;
                                continue;
                            }
                            if (xcol >= p.length || ycol >= p.length || !plot.addPoint(plotKey, x, y)) continue;
                            ++numGoodPoints;
                            continue;
                        }
                        if (FuncCommandNode.this.name.equals("plottime")) {
                            if (xcol < p.length && ycol < p.length && zcol < p.length && wcol < p.length) {
                                if (!plot.addPoint(plotKey, x, y, z, w)) continue;
                                ++numGoodPoints;
                                continue;
                            }
                            if (xcol < p.length && ycol < p.length && zcol < p.length) {
                                if (!plot.addPoint(plotKey, x, y, z)) continue;
                                ++numGoodPoints;
                                continue;
                            }
                            if (xcol < p.length && ycol < p.length) {
                                if (!plot.addPoint(plotKey, x, y)) continue;
                                ++numGoodPoints;
                                continue;
                            }
                            if (xcol >= p.length || !plot.addPoint(plotKey, x)) continue;
                            ++numGoodPoints;
                            continue;
                        }
                        if (!FuncCommandNode.this.name.equals("plothist") || xcol >= p.length || !plot.addPoint(plotKey, x)) continue;
                        ++numGoodPoints;
                    }
                    newFullResult.addChild(new LeafRecordNode(FuncCommandNode.this.name, "" + numGoodPoints));
                } else if (FuncCommandNode.this.name.equals("partialavg")) {
                    FuncCommandNode.this.parser.setNames("window").parse(bindings);
                    int window = FuncCommandNode.this.parser.getInt("window", Integer.MAX_VALUE);
                    double sum = 0.0;
                    int n = 0;
                    List<RecordNode> children = result.getChildren();
                    int i = 0;
                    while (i < children.size()) {
                        double oldx;
                        RecordNode node = children.get(i);
                        double x = node.getDoubleValue();
                        if (NumUtils.isFinite(x)) {
                            sum += x;
                            ++n;
                        }
                        if (i - window >= 0 && NumUtils.isFinite(oldx = children.get(i - window).getDoubleValue())) {
                            sum -= oldx;
                            --n;
                        }
                        newFullResult.addChild(node.shallowCopy(node.getKey(), "" + sum / (double)n));
                        ++i;
                    }
                } else if (FuncCommandNode.this.name.equals("sort")) {
                    FuncCommandNode.this.parser.setNames("n").parse(bindings);
                    boolean reverse = false;
                    int n = FuncCommandNode.this.parser.getInt("n", result.numChildren());
                    if (n < 0) {
                        n = -n;
                        reverse = true;
                    }
                    if (n > result.numChildren()) {
                        n = result.numChildren();
                    }
                    ArrayList<Pair<Double, RecordNode>> pairs = new ArrayList<Pair<Double, RecordNode>>();
                    for (RecordNode node : result.getChildren()) {
                        pairs.add(new Pair<Double, RecordNode>(node.getDoubleValue(), node));
                    }
                    ListUtils.partialSort(pairs, n, reverse ? new Pair.ReverseFirstComparator() : new Pair.FirstComparator());
                    int i = 0;
                    while (i < n) {
                        newFullResult.addChild((RecordNode)((Pair)pairs.get(i)).getSecond());
                        ++i;
                    }
                } else {
                    throw new RuntimeException("Unknown command: " + FuncCommandNode.this.name);
                }
            }
            return this.localEnv.applyHint(newResult);
        }
    }
}

