/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.Fmt;
import java.util.HashSet;

public class EvalResult {
    private double pp;
    private double pn;
    private double np;
    private double nn;
    private double count;

    public EvalResult() {
    }

    public EvalResult(double numTrueAndPred, double numTrue, double numPred) {
        this.pp = numTrueAndPred;
        this.pn = numTrue - numTrueAndPred;
        this.np = numPred - numTrueAndPred;
        this.nn = 0.0;
        this.count = numTrue + numPred - numTrueAndPred;
    }

    public void add(double trueProb, double predProb) {
        this.pp += trueProb * predProb;
        this.pn += trueProb * (1.0 - predProb);
        this.np += (1.0 - trueProb) * predProb;
        this.nn += (1.0 - trueProb) * (1.0 - predProb);
        this.count += 1.0;
    }

    public void add(boolean trueVal, boolean predVal) {
        this.add(trueVal ? 1 : 0, predVal ? 1 : 0);
    }

    public void add(EvalResult r) {
        this.pp += r.pp;
        this.pn += r.pn;
        this.np += r.np;
        this.nn += r.nn;
        this.count += r.count;
    }

    public <T> void add(HashSet<T> trueSet, HashSet<T> predSet) {
        for (T x : trueSet) {
            this.add(true, predSet.contains(x));
        }
        for (T x : predSet) {
            if (trueSet.contains(x)) continue;
            this.add(false, true);
        }
    }

    public double precision() {
        return this.pp / (this.pp + this.np);
    }

    public double recall() {
        return this.pp / (this.pp + this.pn);
    }

    public double falsePos() {
        return this.np / (this.pp + this.np);
    }

    public double trueNeg() {
        return this.pn / (this.pp + this.pn);
    }

    public double count() {
        return this.count;
    }

    public double numTrue() {
        return this.pp + this.pn;
    }

    public double numPred() {
        return this.pp + this.np;
    }

    public double f1() {
        double p = this.precision();
        double r = this.recall();
        return 2.0 * p * r / (p + r);
    }

    public String toString() {
        return String.format("Precision = %s, recall = %s, F1 = %s (%s)", Fmt.D(this.precision()), Fmt.D(this.recall()), Fmt.D(this.f1()), Fmt.D(this.count()));
    }
}

