/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

public class DoubleVec {
    private double[] data;
    private int n;

    public DoubleVec() {
        this.data = new double[0];
        this.n = 0;
    }

    public DoubleVec(int cap) {
        this.data = new double[cap];
        this.n = 0;
    }

    public DoubleVec(double[] data) {
        this.data = (double[])data.clone();
        this.n = data.length;
    }

    public double get(int i) {
        if (i >= this.n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[i];
    }

    public double set(int i, double x) {
        if (i >= this.n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.data[i] = x;
        return x;
    }

    public double setGrow(int i, double x) {
        if (i >= this.n) {
            if (i >= this.data.length) {
                this.setCap((i + 1) * 2);
            }
            this.n = i + 1;
        }
        this.data[i] = x;
        return x;
    }

    public void add(double x) {
        this.setGrow(this.n, x);
    }

    public void multAll(double d) {
        int i = 0;
        while (i < this.n) {
            int n = i++;
            this.data[n] = this.data[n] * d;
        }
    }

    public void setCap(int cap) {
        if (cap < this.n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double[] newData = new double[cap];
        System.arraycopy(this.data, 0, newData, 0, this.n);
        this.data = newData;
    }

    public void trimToSize() {
        this.setCap(this.n);
    }

    public int size() {
        return this.n;
    }
}

