/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.treeapprox;

import edu.pku.coli.io.CCGPARGWriter;
import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import edu.pku.coli.treeapprox.DAG2TreeBFS;
import edu.pku.coli.treeapprox.DAG2TreeDFS;
import edu.pku.coli.treeapprox.DAG2TreeDFS_ForwardEdgeFirst;
import edu.pku.coli.treeapprox.DAG2TreeNonProjectiveSimple;
import edu.pku.coli.treeapprox.DAG2TreePhraseStructureTree;
import edu.pku.coli.treeapprox.DAG2TreeProjectiveSimple;
import edu.pku.coli.treeapprox.DAG2TreeTransformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TransformerConll2SDP {
    private static DAG2TreeTransformer tree2dag;
    private static String transformer;

    static void initialization() {
        if (transformer.equalsIgnoreCase("dfs")) {
            tree2dag = new DAG2TreeDFS();
        } else if (transformer.equalsIgnoreCase("iteration")) {
            tree2dag = new DAG2TreeDFS_ForwardEdgeFirst();
        } else if (transformer.equalsIgnoreCase("bfs")) {
            tree2dag = new DAG2TreeBFS();
        } else if (transformer.equalsIgnoreCase("projective")) {
            tree2dag = new DAG2TreeProjectiveSimple();
        } else if (transformer.equalsIgnoreCase("nonprojective")) {
            tree2dag = new DAG2TreeNonProjectiveSimple();
        }
    }

    public static void main(String[] args) throws Exception {
        String inFilename = args[0];
        String outFilename = args[1];
        transformer = args[2];
        if (transformer.equalsIgnoreCase("pstree")) {
            String newmap;
            DAG2TreePhraseStructureTree _dag2tree = new DAG2TreePhraseStructureTree();
            CCGPARGWriter writer = new CCGPARGWriter(outFilename);
            File file = new File(inFilename);
            FileInputStream fistream = new FileInputStream(file);
            InputStreamReader inreader = new InputStreamReader(fistream);
            BufferedReader reader = new BufferedReader(inreader);
            while ((newmap = reader.readLine()) != null) {
                SentenceForDAGParsing sent = _dag2tree.toDAG(newmap.toCharArray());
                List<String> list_words = Arrays.asList(sent.words());
                List<String> list_poss = Arrays.asList(sent.tags());
                List<Object> list_lemmas = new ArrayList();
                if (sent.lemmas() == null) {
                    int tmpi = 0;
                    while (tmpi < sent.numOfWords()) {
                        list_lemmas.add("");
                        ++tmpi;
                    }
                } else {
                    list_lemmas = Arrays.asList(sent.lemmas());
                }
                writer.printOneSentenceSDP(sent.getGoldDAG(), list_words, list_lemmas, list_poss, sent.id());
            }
            writer.close();
        } else {
            DAGSentenceReader reader;
            TransformerConll2SDP.initialization();
            CCGPARGWriter writer = new CCGPARGWriter(outFilename);
            DAGSentenceReader it = reader = DAGSentenceReader.treesReaderFromCoNLL06(inFilename);
            for (SentenceForDAGParsing sent : it) {
                PredicateArgumentAdjunctDAG map = sent.getGoldDAG();
                PredicateArgumentAdjunctDAG newmap = tree2dag.toDAG(map);
                List<String> list_words = Arrays.asList(sent.words());
                List<String> list_poss = Arrays.asList(sent.tags());
                List<Object> list_lemmas = new ArrayList();
                if (sent.lemmas() == null) {
                    int tmpi = 0;
                    while (tmpi < sent.numOfWords()) {
                        list_lemmas.add("");
                        ++tmpi;
                    }
                } else {
                    list_lemmas = Arrays.asList(sent.lemmas());
                }
                writer.printOneSentenceSDP(newmap, list_words, list_lemmas, list_poss, sent.id());
            }
            writer.close();
        }
    }
}

