/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import edu.pku.coli.ccg.CCGNode;
import edu.pku.coli.io.XMLParseResultIO;
import edu.pku.coli.syntax.ConstTree;
import edu.pku.coli.viewer.DepTree;
import edu.pku.coli.viewer.Token;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLBatchReader {
    XMLParseResultIO reader;
    private ArrayList<LinkedHashMap<Integer, Token>> tokenLists = new ArrayList();
    private ArrayList<ConstTree> constTreebank = new ArrayList();
    private ArrayList<DepTree> depTreebank = new ArrayList();
    private ArrayList<DepTree> deepdepTreebank = new ArrayList();
    private ArrayList<CCGNode> CCGTreebank = new ArrayList();
    private ArrayList<Element> LFGStructbank = new ArrayList();
    private String path;
    private String low;
    private String high;
    private boolean verbose;
    private boolean[] masks = new boolean[6];

    public XMLBatchReader(String path) {
        this.path = path;
    }

    public XMLBatchReader(String path, boolean verbose) {
        this.path = path;
        this.verbose = verbose;
    }

    public XMLBatchReader(String path, boolean[] masks) {
        this.path = path;
        if (this.masks.length == masks.length) {
            this.masks = masks;
        }
    }

    public XMLBatchReader(String path, boolean verbose, boolean[] masks) {
        this.path = path;
        this.verbose = verbose;
        if (this.masks.length == masks.length) {
            this.masks = masks;
        }
    }

    public void importFromFile() throws IOException, SAXException {
        File file = new File(this.path);
        if (this.verbose) {
            System.out.println("steping into " + file.getAbsolutePath());
        }
        if (this.low == null) {
            this.low = "\u0000";
        }
        if (this.high == null) {
            this.high = "\uffff";
        }
        this.importFromFileRecursive(file, this.low, this.high);
    }

    public void importFromFileRecursive(File dir, String low, String high) throws IOException, SAXException {
        block13: {
            File[] subdirs;
            block12: {
                if (!dir.isFile()) break block12;
                String filename = dir.getName();
                int comp1 = filename.compareTo(low);
                int comp2 = filename.compareTo(high);
                if (comp1 < 0 || comp2 > 0) break block13;
                this.reader = new XMLParseResultIO(dir.getAbsolutePath());
                this.reader.setMasks(this.masks);
                this.reader.importFromFile();
                if (!this.masks[0]) {
                    this.tokenLists.addAll(this.reader.getTokenLists());
                }
                if (!this.masks[1]) {
                    this.constTreebank.addAll(this.reader.getConstTreebank());
                }
                if (!this.masks[2]) {
                    this.depTreebank.addAll(this.reader.getDepTreebank());
                }
                if (!this.masks[3]) {
                    this.deepdepTreebank.addAll(this.reader.getDeepdepTreebank());
                }
                if (!this.masks[4]) {
                    this.CCGTreebank.addAll(this.reader.getCCGTreebank());
                }
                if (!this.masks[5]) {
                    this.LFGStructbank.addAll(this.reader.getLFGStructbank());
                }
                if (!this.verbose) break block13;
                System.out.println("importing from " + filename);
                break block13;
            }
            File[] fileArray = subdirs = dir.listFiles();
            int n = subdirs.length;
            int n2 = 0;
            while (n2 < n) {
                File subdir = fileArray[n2];
                if (subdir.isFile()) {
                    String filename = subdir.getName();
                    int comp1 = filename.compareTo(low);
                    int comp2 = filename.compareTo(high);
                    if (comp1 >= 0 && comp2 <= 0) {
                        this.reader = new XMLParseResultIO(subdir.getAbsolutePath());
                        this.reader.setMasks(this.masks);
                        this.reader.importFromFile();
                        this.tokenLists.addAll(this.reader.getTokenLists());
                        this.constTreebank.addAll(this.reader.getConstTreebank());
                        this.depTreebank.addAll(this.reader.getDepTreebank());
                        this.deepdepTreebank.addAll(this.reader.getDeepdepTreebank());
                        this.CCGTreebank.addAll(this.reader.getCCGTreebank());
                        this.LFGStructbank.addAll(this.reader.getLFGStructbank());
                        if (this.verbose) {
                            System.out.println("importing from " + filename);
                        }
                    }
                } else {
                    if (this.verbose) {
                        System.out.println("steping into " + subdir.getAbsolutePath());
                    }
                    this.importFromFileRecursive(subdir, low, high);
                }
                ++n2;
            }
        }
    }

    public ArrayList<LinkedHashMap<Integer, Token>> getTokenLists() {
        return this.tokenLists;
    }

    public void setTokenLists(ArrayList<LinkedHashMap<Integer, Token>> tokenLists) {
        this.tokenLists = tokenLists;
    }

    public ArrayList<ConstTree> getConstTreebank() {
        return this.constTreebank;
    }

    public void setConstTreebank(ArrayList<ConstTree> constTreebank) {
        this.constTreebank = constTreebank;
    }

    public ArrayList<DepTree> getDepTreebank() {
        return this.depTreebank;
    }

    public void setDepTreebank(ArrayList<DepTree> depTreebank) {
        this.depTreebank = depTreebank;
    }

    public ArrayList<DepTree> getDeepdepTreebank() {
        return this.deepdepTreebank;
    }

    public void setDeepdepTreebank(ArrayList<DepTree> deepdepTreebank) {
        this.deepdepTreebank = deepdepTreebank;
    }

    public ArrayList<CCGNode> getCCGTreebank() {
        return this.CCGTreebank;
    }

    public void setCCGTreebank(ArrayList<CCGNode> cCGTreebank) {
        this.CCGTreebank = cCGTreebank;
    }

    public ArrayList<Element> getLFGStructbank() {
        return this.LFGStructbank;
    }

    public void setLFGStructbank(ArrayList<Element> lFGStructbank) {
        this.LFGStructbank = lFGStructbank;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getLow() {
        return this.low;
    }

    public void setLow(String low) {
        this.low = low;
    }

    public String getHigh() {
        return this.high;
    }

    public void setHigh(String high) {
        this.high = high;
    }
}

