/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileRecursor
implements Iterable<File> {
    String _fileName;
    FileFilter _filter;

    public FileRecursor(String filename) {
        this(filename, null);
    }

    public FileRecursor(String filename, FileFilter filter) {
        this._fileName = filename;
        this._filter = filter;
    }

    @Override
    public Iterator<File> iterator() {
        return new FileIterator(this._fileName, this._filter);
    }

    public static void main(String[] args) {
        String s = "E:/data/ccg_ch/test";
        FileRecursor fi = new FileRecursor(s);
        for (File f : fi) {
            System.out.println(f);
        }
    }

    class FileIterator
    implements Iterator<File> {
        List<File> _files;
        List<File> _dirs;
        File _next;
        FileFilter _filter;

        public FileIterator(String s) {
            this(s, null);
        }

        public FileIterator(String s, FileFilter filter) {
            this._next = new File(s);
            this._files = new ArrayList<File>();
            this._dirs = new ArrayList<File>();
            this._filter = filter;
            if (this._next.isDirectory()) {
                this._dirs.add(this._next);
                while (this._files.size() == 0) {
                    if (this._dirs.size() != 0) {
                        this._next = this._dirs.remove(0);
                        File[] fileArray = this._next.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (f.isDirectory()) {
                                this._dirs.add(f);
                            } else if (filter == null || filter.accept(f)) {
                                this._files.add(f);
                            }
                            ++n2;
                        }
                        continue;
                    }
                    break;
                }
            } else if (filter == null || filter.accept(this._next)) {
                this._files.add(this._next);
            }
        }

        @Override
        public boolean hasNext() {
            return this._files.size() > 0;
        }

        @Override
        public File next() {
            File ret = null;
            if (this._files.size() > 0) {
                ret = this._files.remove(0);
            }
            while (this._files.size() == 0) {
                if (this._dirs.size() == 0) break;
                this._next = this._dirs.remove(0);
                File[] fileArray = this._next.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        this._dirs.add(f);
                    } else if (this._filter == null || this._filter.accept(f)) {
                        this._files.add(f);
                    }
                    ++n2;
                }
                if (ret != null || this._files.size() <= 0) continue;
                ret = this._files.remove(0);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

