/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import edu.pku.coli.ccg.CCGNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class CCGBankReader
implements Iterable<CCGNode> {
    BufferedReader _br;

    public CCGBankReader(String filename) throws IOException {
        this._br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
    }

    public CCGBankReader(File filename) throws IOException {
        this._br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
    }

    public CCGBankReader(BufferedReader br) {
        this._br = br;
    }

    public void shutdown() {
        try {
            this._br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Iterator<CCGNode> iterator() {
        try {
            return new CCGBankIterator(this._br);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        CCGBankReader reader = new CCGBankReader("E:/data/ccg_ch/test/chtb_0001.ccg");
        for (CCGNode cn : reader) {
            System.out.println(cn.source);
        }
        reader.shutdown();
    }

    class CCGBankIterator
    implements Iterator<CCGNode> {
        BufferedReader _br;
        CCGNode _next = null;
        int _count = 0;

        public CCGBankIterator(BufferedReader br) throws IOException {
            this._br = br;
            String s = this._br.readLine();
            String cache = null;
            while (s != null) {
                if ((s = s.trim()).length() == 0) {
                    s = this._br.readLine();
                    continue;
                }
                if (s.charAt(0) != '(') {
                    cache = s;
                    s = this._br.readLine();
                    continue;
                }
                CCGNode c = CCGNode.getCCGNodeFromString((String)s, (String)cache);
                c.source = cache;
                cache = null;
                this._next = c;
                ++this._count;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public CCGNode next() {
            CCGNode ret = this._next;
            this._next = null;
            try {
                String s = this._br.readLine();
                String cache = null;
                while (s != null) {
                    if ((s = s.trim()).length() == 0) {
                        s = this._br.readLine();
                        continue;
                    }
                    if (s.charAt(0) != '(') {
                        cache = s;
                        s = this._br.readLine();
                        continue;
                    }
                    CCGNode c = CCGNode.getCCGNodeFromString((String)s, (String)cache);
                    c.source = cache;
                    cache = null;
                    this._next = c;
                    ++this._count;
                    if (this._count % 100 == 0) {
                        System.out.print('.');
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

