/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.BufferedDeletes;
import org.apache.lucene.index.ByteBlockPool;
import org.apache.lucene.index.CompoundFileWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocConsumerPerThread;
import org.apache.lucene.index.DocFieldConsumers;
import org.apache.lucene.index.DocFieldProcessor;
import org.apache.lucene.index.DocInverter;
import org.apache.lucene.index.DocumentsWriterThreadState;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeDocIDRemapper;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NormsWriter;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StoredFieldsWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermVectorsTermsWriter;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ArrayUtil;

final class DocumentsWriter {
    IndexWriter writer;
    Directory directory;
    String segment;
    private String docStoreSegment;
    private int docStoreOffset;
    private int nextDocID;
    private int numDocsInRAM;
    int numDocsInStore;
    private static final int MAX_THREAD_STATE = 5;
    private DocumentsWriterThreadState[] threadStates = new DocumentsWriterThreadState[0];
    private final HashMap threadBindings = new HashMap();
    private int pauseThreads;
    boolean flushPending;
    boolean bufferIsFull;
    private boolean aborting;
    private DocFieldProcessor docFieldProcessor;
    PrintStream infoStream;
    int maxFieldLength = 10000;
    Similarity similarity;
    List newFiles;
    final DocConsumer consumer;
    private BufferedDeletes deletesInRAM = new BufferedDeletes();
    private BufferedDeletes deletesFlushed = new BufferedDeletes();
    private int maxBufferedDeleteTerms = -1;
    private long ramBufferSize = 0x1000000L;
    private long waitQueuePauseBytes = (long)((double)this.ramBufferSize * 0.1);
    private long waitQueueResumeBytes = (long)((double)this.ramBufferSize * 0.05);
    private long freeTrigger = 0x10CCCCCL;
    private long freeLevel = 0xF33333L;
    private int maxBufferedDocs = -1;
    private int flushedDocCount;
    private boolean closed;
    private Collection abortedFiles;
    private FlushState flushState;
    final List openFiles = new ArrayList();
    final List closedFiles = new ArrayList();
    final SkipDocWriter skipDocWriter = new SkipDocWriter();
    long numBytesAlloc;
    long numBytesUsed;
    NumberFormat nf = NumberFormat.getInstance();
    static final int OBJECT_HEADER_BYTES = 8;
    static final int POINTER_NUM_BYTE = 4;
    static final int INT_NUM_BYTE = 4;
    static final int CHAR_NUM_BYTE = 2;
    static final int BYTE_BLOCK_SHIFT = 15;
    static final int BYTE_BLOCK_SIZE = 32768;
    static final int BYTE_BLOCK_MASK = Short.MAX_VALUE;
    static final int BYTE_BLOCK_NOT_MASK = Short.MIN_VALUE;
    static final int INT_BLOCK_SHIFT = 13;
    static final int INT_BLOCK_SIZE = 8192;
    static final int INT_BLOCK_MASK = 8191;
    private ArrayList freeIntBlocks = new ArrayList();
    ByteBlockAllocator byteBlockAllocator = new ByteBlockAllocator();
    static final int CHAR_BLOCK_SHIFT = 14;
    static final int CHAR_BLOCK_SIZE = 16384;
    static final int CHAR_BLOCK_MASK = 16383;
    static final int MAX_TERM_LENGTH = 16383;
    private ArrayList freeCharBlocks = new ArrayList();
    final WaitQueue waitQueue = new WaitQueue();
    static final /* synthetic */ boolean $assertionsDisabled;

    synchronized void updateFlushedDocCount(int n) {
        this.flushedDocCount += n;
    }

    synchronized int getFlushedDocCount() {
        return this.flushedDocCount;
    }

    synchronized void setFlushedDocCount(int n) {
        this.flushedDocCount = n;
    }

    DocumentsWriter(Directory directory, IndexWriter writer) throws IOException {
        this.directory = directory;
        this.writer = writer;
        this.similarity = writer.getSimilarity();
        this.flushedDocCount = writer.maxDoc();
        TermVectorsTermsWriter termVectorsWriter = new TermVectorsTermsWriter(this);
        FreqProxTermsWriter freqProxWriter = new FreqProxTermsWriter();
        TermsHash termsHash = new TermsHash(this, true, freqProxWriter, new TermsHash(this, false, termVectorsWriter, null));
        NormsWriter normsWriter = new NormsWriter();
        DocInverter docInverter = new DocInverter(termsHash, normsWriter);
        StoredFieldsWriter fieldsWriter = new StoredFieldsWriter(this);
        DocFieldConsumers docFieldConsumers = new DocFieldConsumers(docInverter, fieldsWriter);
        this.docFieldProcessor = new DocFieldProcessor(this, docFieldConsumers);
        this.consumer = this.docFieldProcessor;
    }

    boolean hasProx() {
        return this.docFieldProcessor.fieldInfos.hasProx();
    }

    synchronized void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].docState.infoStream = infoStream;
        }
    }

    synchronized void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].docState.maxFieldLength = maxFieldLength;
        }
    }

    synchronized void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].docState.similarity = similarity;
        }
    }

    synchronized void setRAMBufferSizeMB(double mb) {
        if (mb == -1.0) {
            this.ramBufferSize = -1L;
            this.waitQueuePauseBytes = 0x400000L;
            this.waitQueueResumeBytes = 0x200000L;
        } else {
            this.ramBufferSize = (long)(mb * 1024.0 * 1024.0);
            this.waitQueuePauseBytes = (long)((double)this.ramBufferSize * 0.1);
            this.waitQueueResumeBytes = (long)((double)this.ramBufferSize * 0.05);
            this.freeTrigger = (long)(1.05 * (double)this.ramBufferSize);
            this.freeLevel = (long)(0.95 * (double)this.ramBufferSize);
        }
    }

    synchronized double getRAMBufferSizeMB() {
        if (this.ramBufferSize == -1L) {
            return this.ramBufferSize;
        }
        return (double)this.ramBufferSize / 1024.0 / 1024.0;
    }

    void setMaxBufferedDocs(int count) {
        this.maxBufferedDocs = count;
    }

    int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    String getSegment() {
        return this.segment;
    }

    int getNumDocsInRAM() {
        return this.numDocsInRAM;
    }

    synchronized String getDocStoreSegment() {
        return this.docStoreSegment;
    }

    int getDocStoreOffset() {
        return this.docStoreOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String closeDocStore() throws IOException {
        String string;
        block5: {
            if (!$assertionsDisabled && !this.allThreadsIdle()) {
                throw new AssertionError();
            }
            if (this.infoStream != null) {
                this.message("closeDocStore: " + this.openFiles.size() + " files to flush to segment " + this.docStoreSegment + " numDocs=" + this.numDocsInStore);
            }
            boolean success = false;
            try {
                this.initFlushState(true);
                this.closedFiles.clear();
                this.consumer.closeDocStore(this.flushState);
                if (!$assertionsDisabled && 0 != this.openFiles.size()) {
                    throw new AssertionError();
                }
                String s = this.docStoreSegment;
                this.docStoreSegment = null;
                this.docStoreOffset = 0;
                this.numDocsInStore = 0;
                success = true;
                string = s;
                Object var5_4 = null;
                if (success) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (success) break block6;
                    this.abort();
                }
                throw throwable;
            }
            this.abort();
        }
        return string;
    }

    Collection abortedFiles() {
        return this.abortedFiles;
    }

    void message(String message) {
        this.writer.message("DW: " + message);
    }

    synchronized List openFiles() {
        return (List)((ArrayList)this.openFiles).clone();
    }

    synchronized List closedFiles() {
        return (List)((ArrayList)this.closedFiles).clone();
    }

    synchronized void addOpenFile(String name) {
        if (!$assertionsDisabled && this.openFiles.contains(name)) {
            throw new AssertionError();
        }
        this.openFiles.add(name);
    }

    synchronized void removeOpenFile(String name) {
        if (!$assertionsDisabled && !this.openFiles.contains(name)) {
            throw new AssertionError();
        }
        this.openFiles.remove(name);
        this.closedFiles.add(name);
    }

    synchronized void setAborting() {
        this.aborting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void abort() throws IOException {
        try {
            this.message("docWriter: now abort");
            this.waitQueue.abort();
            this.pauseAllThreads();
            try {
                if (!$assertionsDisabled && 0 != this.waitQueue.numWaiting) {
                    throw new AssertionError();
                }
                this.waitQueue.waitingBytes = 0L;
                try {
                    this.abortedFiles = this.openFiles();
                }
                catch (Throwable t) {
                    this.abortedFiles = null;
                }
                this.deletesInRAM.clear();
                this.openFiles.clear();
                for (int i = 0; i < this.threadStates.length; ++i) {
                    try {
                        this.threadStates[i].consumer.abort();
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    this.consumer.abort();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.docStoreSegment = null;
                this.numDocsInStore = 0;
                this.docStoreOffset = 0;
                this.doAfterFlush();
                Object var4_5 = null;
                this.resumeAllThreads();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.resumeAllThreads();
                throw throwable;
            }
            Object var6_8 = null;
            this.aborting = false;
            this.notifyAll();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.aborting = false;
            this.notifyAll();
            throw throwable;
        }
    }

    private void doAfterFlush() throws IOException {
        if (!$assertionsDisabled && !this.allThreadsIdle()) {
            throw new AssertionError();
        }
        this.threadBindings.clear();
        this.waitQueue.reset();
        this.segment = null;
        this.numDocsInRAM = 0;
        this.nextDocID = 0;
        this.bufferIsFull = false;
        this.flushPending = false;
        for (int i = 0; i < this.threadStates.length; ++i) {
            this.threadStates[i].doAfterFlush();
        }
        this.numBytesUsed = 0L;
    }

    synchronized boolean pauseAllThreads() {
        ++this.pauseThreads;
        while (!this.allThreadsIdle()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.aborting;
    }

    synchronized void resumeAllThreads() {
        --this.pauseThreads;
        if (!$assertionsDisabled && this.pauseThreads < 0) {
            throw new AssertionError();
        }
        if (0 == this.pauseThreads) {
            this.notifyAll();
        }
    }

    private synchronized boolean allThreadsIdle() {
        for (int i = 0; i < this.threadStates.length; ++i) {
            if (this.threadStates[i].isIdle) continue;
            return false;
        }
        return true;
    }

    private synchronized void initFlushState(boolean onlyDocStore) {
        this.initSegmentName(onlyDocStore);
        if (this.flushState == null) {
            this.flushState = new FlushState();
            this.flushState.directory = this.directory;
            this.flushState.docWriter = this;
        }
        this.flushState.docStoreSegmentName = this.docStoreSegment;
        this.flushState.segmentName = this.segment;
        this.flushState.numDocsInRAM = this.numDocsInRAM;
        this.flushState.numDocsInStore = this.numDocsInStore;
        this.flushState.flushedFiles = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized int flush(boolean closeDocStore) throws IOException {
        block15: {
            if (!$assertionsDisabled && !this.allThreadsIdle()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.numDocsInRAM <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.nextDocID != this.numDocsInRAM) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.waitQueue.numWaiting != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.waitQueue.waitingBytes != 0L) {
                throw new AssertionError();
            }
            this.initFlushState(false);
            this.docStoreOffset = this.numDocsInStore;
            if (this.infoStream != null) {
                this.message("flush postings as segment " + this.flushState.segmentName + " numDocs=" + this.numDocsInRAM);
            }
            boolean success = false;
            try {
                if (closeDocStore) {
                    if (!$assertionsDisabled && this.flushState.docStoreSegmentName == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.flushState.docStoreSegmentName.equals(this.flushState.segmentName)) {
                        throw new AssertionError();
                    }
                    this.closeDocStore();
                    this.flushState.numDocsInStore = 0;
                }
                HashSet<DocConsumerPerThread> threads = new HashSet<DocConsumerPerThread>();
                for (int i = 0; i < this.threadStates.length; ++i) {
                    threads.add(this.threadStates[i].consumer);
                }
                this.consumer.flush(threads, this.flushState);
                if (this.infoStream != null) {
                    long newSegmentSize = this.segmentSize(this.flushState.segmentName);
                    String message = "  oldRAMSize=" + this.numBytesUsed + " newFlushedSize=" + newSegmentSize + " docs/MB=" + this.nf.format((double)this.numDocsInRAM / ((double)newSegmentSize / 1024.0 / 1024.0)) + " new/old=" + this.nf.format(100.0 * (double)newSegmentSize / (double)this.numBytesUsed) + "%";
                    this.message(message);
                }
                this.flushedDocCount += this.flushState.numDocsInRAM;
                this.doAfterFlush();
                success = true;
                Object var8_7 = null;
                if (success) break block15;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (!success) {
                    this.abort();
                }
                throw throwable;
            }
            this.abort();
        }
        if (!$assertionsDisabled && this.waitQueue.waitingBytes != 0L) {
            throw new AssertionError();
        }
        return this.flushState.numDocsInRAM;
    }

    void createCompoundFile(String segment) throws IOException {
        CompoundFileWriter cfsWriter = new CompoundFileWriter(this.directory, segment + "." + "cfs");
        Iterator it = this.flushState.flushedFiles.iterator();
        while (it.hasNext()) {
            cfsWriter.addFile((String)it.next());
        }
        cfsWriter.close();
    }

    synchronized boolean setFlushPending() {
        if (this.flushPending) {
            return false;
        }
        this.flushPending = true;
        return true;
    }

    synchronized void clearFlushPending() {
        this.flushPending = false;
    }

    synchronized void pushDeletes() {
        this.deletesFlushed.update(this.deletesInRAM);
    }

    synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    synchronized void initSegmentName(boolean onlyDocStore) {
        if (!(this.segment != null || onlyDocStore && this.docStoreSegment != null)) {
            this.segment = this.writer.newSegmentName();
            if (!$assertionsDisabled && this.numDocsInRAM != 0) {
                throw new AssertionError();
            }
        }
        if (this.docStoreSegment == null) {
            this.docStoreSegment = this.segment;
            if (!$assertionsDisabled && this.numDocsInStore != 0) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DocumentsWriterThreadState getThreadState(Document doc, Term delTerm) throws IOException {
        DocumentsWriterThreadState state = (DocumentsWriterThreadState)this.threadBindings.get(Thread.currentThread());
        if (state == null) {
            DocumentsWriterThreadState minThreadState = null;
            for (int i = 0; i < this.threadStates.length; ++i) {
                DocumentsWriterThreadState ts = this.threadStates[i];
                if (minThreadState != null && ts.numThreads >= minThreadState.numThreads) continue;
                minThreadState = ts;
            }
            if (minThreadState != null && (minThreadState.numThreads == 0 || this.threadStates.length >= 5)) {
                state = minThreadState;
                ++state.numThreads;
            } else {
                DocumentsWriterThreadState[] newArray = new DocumentsWriterThreadState[1 + this.threadStates.length];
                if (this.threadStates.length > 0) {
                    System.arraycopy(this.threadStates, 0, newArray, 0, this.threadStates.length);
                }
                DocumentsWriterThreadState documentsWriterThreadState = new DocumentsWriterThreadState(this);
                newArray[this.threadStates.length] = documentsWriterThreadState;
                state = documentsWriterThreadState;
                this.threadStates = newArray;
            }
            this.threadBindings.put(Thread.currentThread(), state);
        }
        this.waitReady(state);
        this.initSegmentName(false);
        state.isIdle = false;
        boolean success = false;
        try {
            state.docState.docID = this.nextDocID;
            if (!$assertionsDisabled && !this.writer.testPoint("DocumentsWriter.ThreadState.init start")) {
                throw new AssertionError();
            }
            if (delTerm != null) {
                this.addDeleteTerm(delTerm, state.docState.docID);
                state.doFlushAfter = this.timeToFlushDeletes();
            }
            if (!$assertionsDisabled && !this.writer.testPoint("DocumentsWriter.ThreadState.init after delTerm")) {
                throw new AssertionError();
            }
            ++this.nextDocID;
            ++this.numDocsInRAM;
            if (!this.flushPending && this.maxBufferedDocs != -1 && this.numDocsInRAM >= this.maxBufferedDocs) {
                this.flushPending = true;
                state.doFlushAfter = true;
            }
            success = true;
            Object var8_9 = null;
            if (!success) {
                state.isIdle = true;
                this.notifyAll();
                if (state.doFlushAfter) {
                    state.doFlushAfter = false;
                    this.flushPending = false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!success) {
                state.isIdle = true;
                this.notifyAll();
                if (state.doFlushAfter) {
                    state.doFlushAfter = false;
                    this.flushPending = false;
                }
            }
            throw throwable;
        }
        return state;
    }

    boolean addDocument(Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        return this.updateDocument(doc, analyzer, null);
    }

    boolean updateDocument(Term t, Document doc, Analyzer analyzer) throws CorruptIndexException, IOException {
        return this.updateDocument(doc, analyzer, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateDocument(Document doc, Analyzer analyzer, Term delTerm) throws CorruptIndexException, IOException {
        DocumentsWriterThreadState state;
        block19: {
            DocumentsWriter documentsWriter;
            state = this.getThreadState(doc, delTerm);
            DocState docState = state.docState;
            docState.doc = doc;
            docState.analyzer = analyzer;
            boolean success = false;
            try {
                DocWriter perDoc = state.consumer.processDocument();
                this.finishDocument(state, perDoc);
                success = true;
                Object var9_8 = null;
                if (success) break block19;
                documentsWriter = this;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (!success) {
                    DocumentsWriter documentsWriter2 = this;
                    synchronized (documentsWriter2) {
                        if (this.aborting) {
                            state.isIdle = true;
                            this.notifyAll();
                            this.abort();
                        } else {
                            block21: {
                                this.skipDocWriter.docID = docState.docID;
                                boolean success2 = false;
                                try {
                                    this.waitQueue.add(this.skipDocWriter);
                                    success2 = true;
                                    Object var13_16 = null;
                                    if (success2) break block21;
                                    state.isIdle = true;
                                    this.notifyAll();
                                }
                                catch (Throwable throwable2) {
                                    Object var13_17 = null;
                                    if (!success2) {
                                        state.isIdle = true;
                                        this.notifyAll();
                                        this.abort();
                                        return false;
                                    }
                                    throw throwable2;
                                }
                                this.abort();
                                return false;
                            }
                            state.isIdle = true;
                            this.notifyAll();
                            if (state.doFlushAfter) {
                                state.doFlushAfter = false;
                                this.flushPending = false;
                                this.notifyAll();
                            }
                            this.addDeleteDocID(state.docState.docID);
                        }
                    }
                }
                throw throwable;
            }
            synchronized (documentsWriter) {
                if (this.aborting) {
                    state.isIdle = true;
                    this.notifyAll();
                    this.abort();
                } else {
                    block20: {
                        this.skipDocWriter.docID = docState.docID;
                        boolean success2 = false;
                        try {
                            this.waitQueue.add(this.skipDocWriter);
                            success2 = true;
                            Object var13_14 = null;
                            if (success2) break block20;
                            state.isIdle = true;
                            this.notifyAll();
                        }
                        catch (Throwable throwable) {
                            Object var13_15 = null;
                            if (!success2) {
                                state.isIdle = true;
                                this.notifyAll();
                                this.abort();
                                return false;
                            }
                            throw throwable;
                        }
                        this.abort();
                        return false;
                    }
                    state.isIdle = true;
                    this.notifyAll();
                    if (state.doFlushAfter) {
                        state.doFlushAfter = false;
                        this.flushPending = false;
                        this.notifyAll();
                    }
                    this.addDeleteDocID(state.docState.docID);
                }
            }
        }
        return state.doFlushAfter || this.timeToFlushDeletes();
    }

    synchronized int getNumBufferedDeleteTerms() {
        return this.deletesInRAM.numTerms;
    }

    synchronized HashMap getBufferedDeleteTerms() {
        return this.deletesInRAM.terms;
    }

    synchronized void remapDeletes(SegmentInfos infos, int[][] docMaps, int[] delCounts, MergePolicy.OneMerge merge, int mergeDocCount) {
        if (docMaps == null) {
            return;
        }
        MergeDocIDRemapper mapper = new MergeDocIDRemapper(infos, docMaps, delCounts, merge, mergeDocCount);
        this.deletesInRAM.remap(mapper, infos, docMaps, delCounts, merge, mergeDocCount);
        this.deletesFlushed.remap(mapper, infos, docMaps, delCounts, merge, mergeDocCount);
        this.flushedDocCount -= mapper.docShift;
    }

    private synchronized void waitReady(DocumentsWriterThreadState state) {
        while (!this.closed && (state != null && !state.isIdle || this.pauseThreads != 0 || this.flushPending || this.aborting)) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.closed) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
    }

    synchronized boolean bufferDeleteTerms(Term[] terms) throws IOException {
        this.waitReady(null);
        for (int i = 0; i < terms.length; ++i) {
            this.addDeleteTerm(terms[i], this.numDocsInRAM);
        }
        return this.timeToFlushDeletes();
    }

    synchronized boolean bufferDeleteTerm(Term term) throws IOException {
        this.waitReady(null);
        this.addDeleteTerm(term, this.numDocsInRAM);
        return this.timeToFlushDeletes();
    }

    synchronized boolean bufferDeleteQueries(Query[] queries) throws IOException {
        this.waitReady(null);
        for (int i = 0; i < queries.length; ++i) {
            this.addDeleteQuery(queries[i], this.numDocsInRAM);
        }
        return this.timeToFlushDeletes();
    }

    synchronized boolean bufferDeleteQuery(Query query) throws IOException {
        this.waitReady(null);
        this.addDeleteQuery(query, this.numDocsInRAM);
        return this.timeToFlushDeletes();
    }

    synchronized boolean deletesFull() {
        return this.maxBufferedDeleteTerms != -1 && this.deletesInRAM.numTerms + this.deletesInRAM.queries.size() + this.deletesInRAM.docIDs.size() >= this.maxBufferedDeleteTerms;
    }

    private synchronized boolean timeToFlushDeletes() {
        return (this.bufferIsFull || this.deletesFull()) && this.setFlushPending();
    }

    void setMaxBufferedDeleteTerms(int maxBufferedDeleteTerms) {
        this.maxBufferedDeleteTerms = maxBufferedDeleteTerms;
    }

    int getMaxBufferedDeleteTerms() {
        return this.maxBufferedDeleteTerms;
    }

    synchronized boolean hasDeletes() {
        return this.deletesFlushed.any();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean applyDeletes(SegmentInfos infos) throws IOException {
        if (!this.hasDeletes()) {
            return false;
        }
        if (this.infoStream != null) {
            this.message("apply " + this.deletesFlushed.numTerms + " buffered deleted terms and " + this.deletesFlushed.docIDs.size() + " deleted docIDs and " + this.deletesFlushed.queries.size() + " deleted queries on " + infos.size() + " segments.");
        }
        int infosEnd = infos.size();
        int docStart = 0;
        boolean any = false;
        for (int i = 0; i < infosEnd; ++i) {
            Object var11_9;
            Object var9_8;
            SegmentReader reader = SegmentReader.get(infos.info(i), false);
            boolean success = false;
            try {
                any |= this.applyDeletes(reader, docStart);
                docStart += ((IndexReader)reader).maxDoc();
                success = true;
                var9_8 = null;
                if (reader == null) continue;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                if (reader != null) {
                    try {
                        if (success) {
                            ((IndexReader)reader).doCommit();
                        }
                        var11_9 = null;
                    }
                    catch (Throwable throwable2) {
                        var11_9 = null;
                        ((IndexReader)reader).doClose();
                        throw throwable2;
                    }
                    ((IndexReader)reader).doClose();
                    {
                    }
                }
                throw throwable;
            }
            try {
                if (success) {
                    ((IndexReader)reader).doCommit();
                }
                var11_9 = null;
            }
            catch (Throwable throwable) {
                var11_9 = null;
                ((IndexReader)reader).doClose();
                throw throwable;
            }
            ((IndexReader)reader).doClose();
            {
                continue;
            }
        }
        this.deletesFlushed.clear();
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized boolean applyDeletes(IndexReader reader, int docIDStart) throws CorruptIndexException, IOException {
        int limit;
        int docEnd = docIDStart + reader.maxDoc();
        boolean any = false;
        Iterator iter = this.deletesFlushed.terms.entrySet().iterator();
        while (iter.hasNext()) {
            Object var12_14;
            Map.Entry entry = iter.next();
            Term term = (Term)entry.getKey();
            TermDocs docs = reader.termDocs(term);
            if (docs == null) continue;
            limit = ((BufferedDeletes.Num)entry.getValue()).getNum();
            try {
                int docID;
                while (docs.next() && docIDStart + (docID = docs.doc()) < limit) {
                    reader.deleteDocument(docID);
                    any = true;
                }
                var12_14 = null;
            }
            catch (Throwable throwable) {
                var12_14 = null;
                docs.close();
                throw throwable;
            }
            docs.close();
            {
            }
        }
        iter = this.deletesFlushed.docIDs.iterator();
        while (iter.hasNext()) {
            int docID = (Integer)((Object)iter.next());
            if (docID < docIDStart || docID >= docEnd) continue;
            reader.deleteDocument(docID - docIDStart);
            any = true;
        }
        IndexSearcher searcher = new IndexSearcher(reader);
        iter = this.deletesFlushed.queries.entrySet().iterator();
        while (iter.hasNext()) {
            int docID;
            Map.Entry entry = iter.next();
            Query query = (Query)entry.getKey();
            limit = (Integer)entry.getValue();
            Weight weight = query.weight(searcher);
            Scorer scorer = weight.scorer(reader);
            while (scorer.next() && docIDStart + (docID = scorer.doc()) < limit) {
                reader.deleteDocument(docID);
                any = true;
            }
        }
        searcher.close();
        return any;
    }

    private synchronized void addDeleteTerm(Term term, int docCount) {
        BufferedDeletes.Num num = (BufferedDeletes.Num)this.deletesInRAM.terms.get(term);
        int docIDUpto = this.flushedDocCount + docCount;
        if (num == null) {
            this.deletesInRAM.terms.put(term, new BufferedDeletes.Num(docIDUpto));
        } else {
            num.setNum(docIDUpto);
        }
        ++this.deletesInRAM.numTerms;
    }

    private synchronized void addDeleteDocID(int docID) {
        this.deletesInRAM.docIDs.add(new Integer(this.flushedDocCount + docID));
    }

    private synchronized void addDeleteQuery(Query query, int docID) {
        this.deletesInRAM.queries.put(query, new Integer(this.flushedDocCount + docID));
    }

    synchronized boolean doBalanceRAM() {
        return this.ramBufferSize != -1L && !this.bufferIsFull && (this.numBytesUsed >= this.ramBufferSize || this.numBytesAlloc >= this.freeTrigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishDocument(DocumentsWriterThreadState perThread, DocWriter docWriter) throws IOException {
        if (this.doBalanceRAM()) {
            this.balanceRAM();
        }
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            boolean doPause;
            if (!$assertionsDisabled && docWriter != null && docWriter.docID != perThread.docState.docID) {
                throw new AssertionError();
            }
            if (this.aborting) {
                if (docWriter != null) {
                    try {
                        docWriter.abort();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                perThread.isIdle = true;
                this.notifyAll();
                return;
            }
            if (docWriter != null) {
                doPause = this.waitQueue.add(docWriter);
            } else {
                this.skipDocWriter.docID = perThread.docState.docID;
                doPause = this.waitQueue.add(this.skipDocWriter);
            }
            if (doPause) {
                this.waitForWaitQueue();
            }
            if (this.bufferIsFull && !this.flushPending) {
                this.flushPending = true;
                perThread.doFlushAfter = true;
            }
            perThread.isIdle = true;
            this.notifyAll();
        }
    }

    synchronized void waitForWaitQueue() {
        do {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (!this.waitQueue.doResume());
    }

    long getRAMUsed() {
        return this.numBytesUsed;
    }

    private long segmentSize(String segmentName) throws IOException {
        if (!$assertionsDisabled && this.infoStream == null) {
            throw new AssertionError();
        }
        long size = this.directory.fileLength(segmentName + ".tii") + this.directory.fileLength(segmentName + ".tis") + this.directory.fileLength(segmentName + ".frq") + this.directory.fileLength(segmentName + ".prx");
        String normFileName = segmentName + ".nrm";
        if (this.directory.fileExists(normFileName)) {
            size += this.directory.fileLength(normFileName);
        }
        return size;
    }

    synchronized int[] getIntBlock(boolean trackAllocations) {
        int[] b;
        int size = this.freeIntBlocks.size();
        if (0 == size) {
            this.numBytesAlloc += 32768L;
            b = new int[8192];
        } else {
            b = (int[])this.freeIntBlocks.remove(size - 1);
        }
        if (trackAllocations) {
            this.numBytesUsed += 32768L;
        }
        if (!$assertionsDisabled && this.numBytesUsed > this.numBytesAlloc) {
            throw new AssertionError();
        }
        return b;
    }

    synchronized void bytesAllocated(long numBytes) {
        this.numBytesAlloc += numBytes;
        if (!$assertionsDisabled && this.numBytesUsed > this.numBytesAlloc) {
            throw new AssertionError();
        }
    }

    synchronized void bytesUsed(long numBytes) {
        this.numBytesUsed += numBytes;
        if (!$assertionsDisabled && this.numBytesUsed > this.numBytesAlloc) {
            throw new AssertionError();
        }
    }

    synchronized void recycleIntBlocks(int[][] blocks, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.freeIntBlocks.add(blocks[i]);
        }
    }

    synchronized char[] getCharBlock() {
        char[] c;
        int size = this.freeCharBlocks.size();
        if (0 == size) {
            this.numBytesAlloc += 32768L;
            c = new char[16384];
        } else {
            c = (char[])this.freeCharBlocks.remove(size - 1);
        }
        this.numBytesUsed += 32768L;
        if (!$assertionsDisabled && this.numBytesUsed > this.numBytesAlloc) {
            throw new AssertionError();
        }
        return c;
    }

    synchronized void recycleCharBlocks(char[][] blocks, int numBlocks) {
        for (int i = 0; i < numBlocks; ++i) {
            this.freeCharBlocks.add(blocks[i]);
        }
    }

    String toMB(long v) {
        return this.nf.format((double)v / 1024.0 / 1024.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void balanceRAM() {
        long flushTrigger = this.ramBufferSize;
        if (this.numBytesAlloc > this.freeTrigger) {
            if (this.infoStream != null) {
                this.message("  RAM: now balance allocations: usedMB=" + this.toMB(this.numBytesUsed) + " vs trigger=" + this.toMB(flushTrigger) + " allocMB=" + this.toMB(this.numBytesAlloc) + " vs trigger=" + this.toMB(this.freeTrigger) + " byteBlockFree=" + this.toMB(this.byteBlockAllocator.freeByteBlocks.size() * 32768) + " charBlockFree=" + this.toMB(this.freeCharBlocks.size() * 16384 * 2));
            }
            long startBytesAlloc = this.numBytesAlloc;
            int iter = 0;
            boolean any = true;
            while (this.numBytesAlloc > this.freeLevel) {
                DocumentsWriter documentsWriter = this;
                synchronized (documentsWriter) {
                    if (0 == this.byteBlockAllocator.freeByteBlocks.size() && 0 == this.freeCharBlocks.size() && 0 == this.freeIntBlocks.size() && !any) {
                        boolean bl = this.bufferIsFull = this.numBytesUsed > flushTrigger;
                        if (this.infoStream != null) {
                            if (this.numBytesUsed > flushTrigger) {
                                this.message("    nothing to free; now set bufferIsFull");
                            } else {
                                this.message("    nothing to free");
                            }
                        }
                        if (!$assertionsDisabled && this.numBytesUsed > this.numBytesAlloc) {
                            throw new AssertionError();
                        }
                        break;
                    }
                    if (0 == iter % 4 && this.byteBlockAllocator.freeByteBlocks.size() > 0) {
                        this.byteBlockAllocator.freeByteBlocks.remove(this.byteBlockAllocator.freeByteBlocks.size() - 1);
                        this.numBytesAlloc -= 32768L;
                    }
                    if (1 == iter % 4 && this.freeCharBlocks.size() > 0) {
                        this.freeCharBlocks.remove(this.freeCharBlocks.size() - 1);
                        this.numBytesAlloc -= 32768L;
                    }
                    if (2 == iter % 4 && this.freeIntBlocks.size() > 0) {
                        this.freeIntBlocks.remove(this.freeIntBlocks.size() - 1);
                        this.numBytesAlloc -= 32768L;
                    }
                }
                if (3 == iter % 4 && any) {
                    any = this.consumer.freeRAM();
                }
                ++iter;
            }
            if (this.infoStream != null) {
                this.message("    after free: freedMB=" + this.nf.format((double)(startBytesAlloc - this.numBytesAlloc) / 1024.0 / 1024.0) + " usedMB=" + this.nf.format((double)this.numBytesUsed / 1024.0 / 1024.0) + " allocMB=" + this.nf.format((double)this.numBytesAlloc / 1024.0 / 1024.0));
            }
        } else {
            DocumentsWriter documentsWriter = this;
            synchronized (documentsWriter) {
                if (this.numBytesUsed > flushTrigger) {
                    if (this.infoStream != null) {
                        this.message("  RAM: now flush @ usedMB=" + this.nf.format((double)this.numBytesUsed / 1024.0 / 1024.0) + " allocMB=" + this.nf.format((double)this.numBytesAlloc / 1024.0 / 1024.0) + " triggerMB=" + this.nf.format((double)flushTrigger / 1024.0 / 1024.0));
                    }
                    this.bufferIsFull = true;
                }
            }
        }
    }

    static {
        $assertionsDisabled = !DocumentsWriter.class.desiredAssertionStatus();
    }

    private class WaitQueue {
        DocWriter[] waiting = new DocWriter[10];
        int nextWriteDocID;
        int nextWriteLoc;
        int numWaiting;
        long waitingBytes;
        static final /* synthetic */ boolean $assertionsDisabled;

        synchronized void reset() {
            if (!$assertionsDisabled && this.numWaiting != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.waitingBytes != 0L) {
                throw new AssertionError();
            }
            this.nextWriteDocID = 0;
        }

        synchronized boolean doResume() {
            return this.waitingBytes <= DocumentsWriter.this.waitQueueResumeBytes;
        }

        synchronized boolean doPause() {
            return this.waitingBytes > DocumentsWriter.this.waitQueuePauseBytes;
        }

        synchronized void abort() {
            int count = 0;
            for (int i = 0; i < this.waiting.length; ++i) {
                DocWriter doc = this.waiting[i];
                if (doc == null) continue;
                doc.abort();
                this.waiting[i] = null;
                ++count;
            }
            this.waitingBytes = 0L;
            if (!$assertionsDisabled && count != this.numWaiting) {
                throw new AssertionError();
            }
            this.numWaiting = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeDocument(DocWriter doc) throws IOException {
            if (!$assertionsDisabled && doc != DocumentsWriter.this.skipDocWriter && this.nextWriteDocID != doc.docID) {
                throw new AssertionError();
            }
            boolean success = false;
            try {
                doc.finish();
                ++this.nextWriteDocID;
                ++DocumentsWriter.this.numDocsInStore;
                ++this.nextWriteLoc;
                if (!$assertionsDisabled && this.nextWriteLoc > this.waiting.length) {
                    throw new AssertionError();
                }
                if (this.nextWriteLoc == this.waiting.length) {
                    this.nextWriteLoc = 0;
                }
                success = true;
                Object var4_3 = null;
                if (!success) {
                    DocumentsWriter.this.setAborting();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!success) {
                    DocumentsWriter.this.setAborting();
                }
                throw throwable;
            }
        }

        public synchronized boolean add(DocWriter doc) throws IOException {
            if (!$assertionsDisabled && doc.docID < this.nextWriteDocID) {
                throw new AssertionError();
            }
            if (doc.docID == this.nextWriteDocID) {
                this.writeDocument(doc);
                while ((doc = this.waiting[this.nextWriteLoc]) != null) {
                    --this.numWaiting;
                    this.waiting[this.nextWriteLoc] = null;
                    this.waitingBytes -= doc.sizeInBytes();
                    this.writeDocument(doc);
                }
            } else {
                int loc;
                int gap = doc.docID - this.nextWriteDocID;
                if (gap >= this.waiting.length) {
                    DocWriter[] newArray = new DocWriter[ArrayUtil.getNextSize(gap)];
                    if (!$assertionsDisabled && this.nextWriteLoc < 0) {
                        throw new AssertionError();
                    }
                    System.arraycopy(this.waiting, this.nextWriteLoc, newArray, 0, this.waiting.length - this.nextWriteLoc);
                    System.arraycopy(this.waiting, 0, newArray, this.waiting.length - this.nextWriteLoc, this.nextWriteLoc);
                    this.nextWriteLoc = 0;
                    this.waiting = newArray;
                    gap = doc.docID - this.nextWriteDocID;
                }
                if ((loc = this.nextWriteLoc + gap) >= this.waiting.length) {
                    loc -= this.waiting.length;
                }
                if (!$assertionsDisabled && loc >= this.waiting.length) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.waiting[loc] != null) {
                    throw new AssertionError();
                }
                this.waiting[loc] = doc;
                ++this.numWaiting;
                this.waitingBytes += doc.sizeInBytes();
            }
            return this.doPause();
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$DocumentsWriter == null ? (class$org$apache$lucene$index$DocumentsWriter = DocumentsWriter.class$("org.apache.lucene.index.DocumentsWriter")) : class$org$apache$lucene$index$DocumentsWriter).desiredAssertionStatus();
        }
    }

    private class ByteBlockAllocator
    extends ByteBlockPool.Allocator {
        ArrayList freeByteBlocks = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        private ByteBlockAllocator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] getByteBlock(boolean trackAllocations) {
            DocumentsWriter documentsWriter = DocumentsWriter.this;
            synchronized (documentsWriter) {
                byte[] b;
                int size = this.freeByteBlocks.size();
                if (0 == size) {
                    DocumentsWriter.this.numBytesAlloc += 32768L;
                    b = new byte[32768];
                } else {
                    b = (byte[])this.freeByteBlocks.remove(size - 1);
                }
                if (trackAllocations) {
                    DocumentsWriter.this.numBytesUsed += 32768L;
                }
                if (!$assertionsDisabled && DocumentsWriter.this.numBytesUsed > DocumentsWriter.this.numBytesAlloc) {
                    throw new AssertionError();
                }
                return b;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycleByteBlocks(byte[][] blocks, int start, int end) {
            DocumentsWriter documentsWriter = DocumentsWriter.this;
            synchronized (documentsWriter) {
                for (int i = start; i < end; ++i) {
                    this.freeByteBlocks.add(blocks[i]);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$DocumentsWriter == null ? (class$org$apache$lucene$index$DocumentsWriter = DocumentsWriter.class$("org.apache.lucene.index.DocumentsWriter")) : class$org$apache$lucene$index$DocumentsWriter).desiredAssertionStatus();
        }
    }

    private static class SkipDocWriter
    extends DocWriter {
        private SkipDocWriter() {
        }

        void finish() {
        }

        void abort() {
        }

        long sizeInBytes() {
            return 0L;
        }
    }

    static abstract class DocWriter {
        DocWriter next;
        int docID;

        DocWriter() {
        }

        abstract void finish() throws IOException;

        abstract void abort();

        abstract long sizeInBytes();

        void setNext(DocWriter next) {
            this.next = next;
        }
    }

    static class FlushState {
        DocumentsWriter docWriter;
        Directory directory;
        String segmentName;
        String docStoreSegmentName;
        int numDocsInRAM;
        int numDocsInStore;
        Collection flushedFiles;

        FlushState() {
        }

        public String segmentFileName(String ext) {
            return this.segmentName + "." + ext;
        }
    }

    static class DocState {
        DocumentsWriter docWriter;
        Analyzer analyzer;
        int maxFieldLength;
        PrintStream infoStream;
        Similarity similarity;
        int docID;
        Document doc;
        String maxTermPrefix;

        DocState() {
        }

        public boolean testPoint(String name) {
            return this.docWriter.writer.testPoint(name);
        }
    }
}

