/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.metrics;

import java.io.PrintWriter;
import java.util.List;
import jigsaw.metrics.SetEvaluator;
import jigsaw.syntax.Tree;

public class TaggingEval
implements SetEvaluator {
    private double totalToks = 0.0;
    private double totalCorrect = 0.0;
    protected final String str;
    protected final boolean runningAverages;

    public TaggingEval(String str) {
        this(str, true);
    }

    public TaggingEval(String str, boolean runningAverages) {
        this.str = str;
        this.runningAverages = runningAverages;
    }

    public void evaluate(Tree<String> guess, Tree<String> gold) {
        this.evaluate(guess, gold, new PrintWriter(System.out, true));
    }

    public void evaluate(Tree<String> guess, Tree<String> gold, PrintWriter pw) {
        this.evaluate(guess, gold, pw, 1.0);
    }

    @Override
    public void evaluate(Tree<String> guess, Tree<String> gold, PrintWriter pw, double weight) {
        List<Tree<String>> guesspts = guess.getPreTerminals();
        List<Tree<String>> goldpts = gold.getPreTerminals();
        if (guesspts.size() != goldpts.size()) {
            pw.println("Warning: yield length differs: Guess " + guesspts.size() + " / Gold" + goldpts.size());
        }
        double currCorrect = 0.0;
        int i = 0;
        while (i < guesspts.size()) {
            String goldpos;
            String guesspos = guesspts.get(i).getLabel();
            if (guesspos.equals(goldpos = goldpts.get(i).getLabel())) {
                currCorrect += 1.0;
            }
            ++i;
        }
        double currAcc = currCorrect / (double)goldpts.size();
        this.totalCorrect += currCorrect * weight;
        this.totalToks += (double)goldpts.size() * weight;
        pw.format("%s [current] Acc: %.2f", this.str, currAcc * 100.0);
        if (this.runningAverages) {
            pw.format(" - [average] Acc: %.2f", this.totalCorrect / this.totalToks * 100.0);
        }
        pw.println();
    }

    public void display(boolean verbose) {
        this.display(verbose, new PrintWriter(System.out, true));
    }

    @Override
    public void display(boolean verbose, PrintWriter pw) {
        pw.format("%s [summary] Acc: %.2f T#: %d\n", this.str, this.totalCorrect / this.totalToks * 100.0, (int)this.totalToks);
    }
}

